<?php
// CI-ENERGIES — Admin Layout (Header + Sidebar + Container)
// Place ce fichier à la racine de tes pages admin (ex. /public)
// Nécessite: /assets/css/admin-layout.css et /assets/img/logo-ci-energies.png

if (session_status() === PHP_SESSION_NONE) { session_start(); }
$base     = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
$userName = $_SESSION['user_name']  ?? 'Administrateur';
$userRole = $_SESSION['user_role']  ?? 'Admin';
$avatar   = $_SESSION['user_avatar']?? null;
$current  = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));

// Menu: adapte ici si besoin (libellé, icône, ordre)
$menu = [
  ["href" => "dashboard.php", "label" => "Tableau de bord", "icon" => "bi-speedometer2"],
  ["href" => "stats.php",     "label" => "Statistiques",     "icon" => "bi-graph-up"],
  ["href" => "projets.php",   "label" => "Projets",          "icon" => "bi-diagram-3"],
  ["href" => "depenses.php",  "label" => "Dépenses",         "icon" => "bi-receipt"],
  ["href" => "factures.php",  "label" => "Factures",         "icon" => "bi-file-earmark-text"],
  ["href" => "rapport.php",   "label" => "Rapports",         "icon" => "bi-bar-chart-line"],
  ["href" => "users.php",     "label" => "Utilisateurs",     "icon" => "bi-people"],
  ["href" => "settings.php",  "label" => "Paramètres",       "icon" => "bi-gear"]
];

// Variables page (optionnelles) si non définies par la page appelante
$page_title = $page_title ?? 'Tableau de bord';
$breadcrumb = $breadcrumb ?? '<li class="breadcrumb-item"><a href="'.$base.'/dashboard.php">Accueil</a></li><li class="breadcrumb-item active" aria-current="page">'.$page_title.'</li>';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($page_title) ?> | CI-ENERGIES</title>
  <!-- Bootstrap / Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <!-- Thème -->
  <link href="<?= $base ?>/assets/css/admin-layout.css?v=1" rel="stylesheet">
</head>
<body>
  <!-- Ligne d’accent -->
  <div class="topbar-accent"></div>

  <!-- HEADER -->
  <nav class="navbar navbar-expand-lg navbar-branding fixed-top">
    <div class="container-fluid px-3 px-lg-4">
      <button class="btn btn-outline-secondary me-2 d-lg-none" id="btnSidebar"><i class="bi bi-list"></i></button>

      <a class="navbar-brand d-flex align-items-center" href="<?= $base ?>/dashboard.php">
        <img src="<?= $base ?>/assets/img/logo-ci-energies.png" alt="CI-ENERGIES">
        <span class="ms-2 fw-semibold d-none d-sm-inline">Admin</span>
      </a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#topnav" aria-controls="topnav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="topnav">
        <form class="position-relative ms-auto me-lg-3 mb-2 mb-lg-0 header-search" role="search" action="<?= $base ?>/search.php" method="get">
          <i class="bi bi-search"></i>
          <input class="form-control" type="search" name="q" placeholder="Rechercher...">
        </form>

        <ul class="navbar-nav mb-2 mb-lg-0 align-items-center">
          <li class="nav-item me-2">
            <button class="btn btn-sm btn-outline-secondary" id="btnThemeToggle" title="Mode sombre">
              <i class="bi bi-moon-stars"></i>
            </button>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link d-flex align-items-center" href="#" data-bs-toggle="dropdown">
              <?php if ($avatar): ?>
                <img src="<?= htmlspecialchars($avatar) ?>" class="rounded-circle me-2" style="width:28px;height:28px;object-fit:cover;" alt="avatar">
              <?php else: ?>
                <span class="avatar-placeholder me-2"><i class="bi bi-person"></i></span>
              <?php endif; ?>
              <span class="me-1"><?= htmlspecialchars($userName) ?></span>
              <i class="bi bi-caret-down-fill small"></i>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
              <li class="dropdown-header">
                <div class="fw-semibold"><?= htmlspecialchars($userName) ?></div>
                <small class="text-muted"><?= htmlspecialchars($userRole) ?></small>
              </li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item" href="<?= $base ?>/profile.php"><i class="bi bi-person-circle me-2"></i> Profil</a></li>
              <li><a class="dropdown-item" href="<?= $base ?>/settings.php"><i class="bi bi-gear me-2"></i> Paramètres</a></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item text-danger" href="<?= $base ?>/logout.php"><i class="bi bi-box-arrow-right me-2"></i> Se déconnecter</a></li>
            </ul>
          </li>
        </ul>
      </div>
    </div>
  </nav>

  <!-- SIDEBAR -->
  <aside class="sidebar" id="appSidebar" aria-label="Navigation latérale">
    <div class="brand-pane d-lg-flex d-none">
      <img src="<?= $base ?>/assets/img/logo-ci-energies.png" alt="CI-ENERGIES">
      <span class="ms-2 fw-semibold">Admin</span>
    </div>
    <nav class="menu mt-2">
      <div class="menu-title">Navigation</div>
      <ul class="nav flex-column">
        <?php foreach($menu as $it): $href=$it['href']; $active = ($current === basename($href)); ?>
          <li class="nav-item">
            <a class="nav-link <?= $active ? 'active' : '' ?>" href="<?= $base . '/' . htmlspecialchars($href) ?>">
              <i class="bi <?= htmlspecialchars($it['icon']) ?>"></i>
              <span><?= htmlspecialchars($it['label']) ?></span>
            </a>
          </li>
        <?php endforeach; ?>
        <li class="nav-item mt-2">
          <a class="nav-link text-danger" href="<?= $base ?>/logout.php"><i class="bi bi-box-arrow-right"></i> Déconnexion</a>
        </li>
      </ul>
    </nav>
  </aside>

  <!-- CONTENU -->
  <div class="app-wrapper">
    <header class="page-header">
      <div class="container-fluid px-3 px-lg-4 py-3 d-flex align-items-center justify-content-between">
        <h1 class="page-title"><?= htmlspecialchars($page_title) ?></h1>
        <nav aria-label="breadcrumb"><ol class="breadcrumb mb-0"><?= $breadcrumb ?></ol></nav>
      </div>
    </header>

    <main class="container-fluid px-3 px-lg-4 my-4">
      <?php if (!empty($__PAGE_CONTENT__)){ echo $__PAGE_CONTENT__; } else { ?>
        <div class="row g-3">
          <div class="col-md-6 col-xl-3">
            <div class="card p-3">
              <div class="text-muted">Dépenses du mois</div>
              <div class="d-flex align-items-end justify-content-between">
                <div class="kpi-value">12,4 M CFA</div>
                <div class="kpi-trend up"><i class="bi bi-arrow-up-right"></i> +4.2%</div>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-xl-3">
            <div class="card p-3">
              <div class="text-muted">Factures en attente</div>
              <div class="d-flex align-items-end justify-content-between">
                <div class="kpi-value">18</div>
                <div class="kpi-trend down"><i class="bi bi-arrow-down-right"></i> -1</div>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-xl-3">
            <div class="card p-3">
              <div class="text-muted">Projets actifs</div>
              <div class="kpi-value">9</div>
            </div>
          </div>
          <div class="col-md-6 col-xl-3">
            <div class="card p-3">
              <div class="text-muted">Alertes budget</div>
              <div class="kpi-value">3</div>
            </div>
          </div>
        </div>
      <?php } ?>
    </main>

    <footer class="container-fluid px-3 px-lg-4 pb-4 text-muted small">
      © <?= date('Y') ?> CI-ENERGIES — Tous droits réservés.
    </footer>
  </div>

  <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Toggle sidebar mobile
    const btnSidebar = document.getElementById('btnSidebar');
    const sidebar = document.getElementById('appSidebar');
    btnSidebar?.addEventListener('click', () => { sidebar.classList.toggle('show'); });

    // Mode sombre
    document.getElementById('btnThemeToggle')?.addEventListener('click', function(){
      document.body.classList.toggle('theme-dark');
    });
  </script>
</body>
</html>
