<?php
// traitement.php

require_once __DIR__ . '/../../src/includes/config.php';

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['gestionnaire_id'])) {
    header('Location: login.php');
    exit;
}

$dossier_id = $_GET['id'] ?? null;
$error = '';
$success = '';

// Récupérer le dossier avec les nouvelles jointures
$stmt = $pdo->prepare("
    SELECT 
        d.*, 
        tt.libelle AS type_libelle,
        ts.libelle AS situation_libelle,
        s.nom_service,
        st.libelle AS statut_libelle
    FROM dossiers d
    JOIN types_dossier tt ON d.type_id = tt.id
    LEFT JOIN types_situation ts ON d.type_situation_id = ts.id
    JOIN services s ON d.service_cible_id = s.id
    JOIN statuts st ON d.statut_id = st.id
    WHERE d.id = ?
");
$stmt->execute([$dossier_id]);
$dossier = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$dossier) {
    die("Dossier non trouvé.");
}

// 🔍 Récupérer les pièces jointes du dossier
$stmt_pieces = $pdo->prepare("
    SELECT id, nom_fichier, chemin_stockage, taille, date_upload 
    FROM pieces_jointes 
    WHERE dossier_id = ? 
    ORDER BY date_upload DESC
");
$stmt_pieces->execute([$dossier_id]);
$pieces_jointes = $stmt_pieces->fetchAll(PDO::FETCH_ASSOC);

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nouveau_statut = $_POST['statut_id'] ?? null;
    $commentaire_interne = $_POST['commentaire_interne'] ?? '';
    $auteur_notifie = isset($_POST['auteur_notifie']) ? 1 : 0;

    if (!$nouveau_statut) {
        $error = "Veuillez sélectionner un statut.";
    } else {
        try {
            $pdo->beginTransaction();

            // Mettre à jour le statut, commentaire et notification
            $stmt_update = $pdo->prepare("
                UPDATE dossiers 
                SET statut_id = ?, commentaire_interne = ?, auteur_notifie = ?, date_maj = NOW()
                WHERE id = ?
            ");
            $stmt_update->execute([$nouveau_statut, $commentaire_interne, $auteur_notifie, $dossier_id]);

            $pdo->commit();
            $success = "Le dossier a été mis à jour avec succès.";

            // Recharger les données
            $stmt = $pdo->prepare("
                SELECT 
                    d.*, 
                    tt.libelle AS type_libelle,
                    ts.libelle AS situation_libelle,
                    s.nom_service,
                    st.libelle AS statut_libelle
                FROM dossiers d
                JOIN types_dossier tt ON d.type_id = tt.id
                LEFT JOIN types_situation ts ON d.type_situation_id = ts.id
                JOIN services s ON d.service_cible_id = s.id
                JOIN statuts st ON d.statut_id = st.id
                WHERE d.id = ?
            ");
            $stmt->execute([$dossier_id]);
            $dossier = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$dossier) {
                die("Dossier non trouvé après mise à jour.");
            }

            // Recharger les pièces jointes
            $stmt_pieces->execute([$dossier_id]);
            $pieces_jointes = $stmt_pieces->fetchAll(PDO::FETCH_ASSOC);

        } catch (Exception $e) {
            $pdo->rollback();
            $error = "Erreur : " . $e->getMessage();
        }
    }
}

// Récupérer les statuts pour le select
$stmt_stats = $pdo->query("SELECT id, libelle FROM statuts ORDER BY id");
$statuts = $stmt_stats->fetchAll(PDO::FETCH_ASSOC);

// Fonction pour formater la taille des fichiers
function formatTailleFichier($taille) {
    if ($taille >= 1048576) {
        return round($taille / 1048576, 2) . ' Mo';
    } elseif ($taille >= 1024) {
        return round($taille / 1024, 2) . ' Ko';
    } else {
        return $taille . ' o';
    }
}

// 🔍 Fonction pour obtenir le chemin correct des pièces jointes
function getCheminPieceJointe($chemin_stockage) {
    // Si le chemin commence déjà par "uploads/", on le laisse tel quel
    // Sinon, on suppose que c'est un chemin relatif depuis la racine
    if (strpos($chemin_stockage, 'uploads/') === 0) {
        return '../../' . $chemin_stockage;
    }
    return $chemin_stockage;
}
?>

<!-- Inclure le header -->
<?php include 'admin_header.php'; ?>

<div class="container-fluid p-4">
    <!-- En-tête de page -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">Traitement du dossier</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="dashboard.php">Tableau de bord</a></li>
                    <li class="breadcrumb-item active">Traitement</li>
                </ol>
            </nav>
        </div>
        <div>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-arrow-left me-1"></i>Retour
            </a>
        </div>
    </div>

    <div class="row g-4">
        <!-- Colonne principale - Formulaire -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Dossier : <strong><?= htmlspecialchars($dossier['numero_dossier']) ?></strong></h5>
                        <div class="d-flex gap-2">
                            <span class="badge bg-info"><?= htmlspecialchars($dossier['type_libelle']) ?></span>
                            <span class="badge bg-<?= $dossier['mode_depot'] === 'anonyme' ? 'secondary' : 'success' ?>">
                                <?= ucfirst($dossier['mode_depot']) ?>
                            </span>
                            <!-- 🔍 Badge pièces jointes -->
                            <?php if (count($pieces_jointes) > 0): ?>
                                <span class="badge bg-success">
                                    <i class="bi bi-paperclip me-1"></i><?= count($pieces_jointes) ?> pièce(s)
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <?php if ($error): ?>
                        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
                    <?php endif; ?>
                    <?php if ($success): ?>
                        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Statut actuel</label>
                                <div class="form-control-plaintext p-2 bg-light rounded">
                                    <span class="badge bg-<?= 
                                        $dossier['statut_libelle'] === 'Reçu' ? 'info' :
                                        ($dossier['statut_libelle'] === 'En cours d\'analyse' ? 'warning' :
                                        ($dossier['statut_libelle'] === 'Clôturé – action entreprise' ? 'success' :
                                        ($dossier['statut_libelle'] === 'Clôturé – non retenu' ? 'dark' : 'secondary')))
                                    ?> fs-6">
                                        <?= htmlspecialchars($dossier['statut_libelle']) ?>
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label for="statut_id" class="form-label fw-semibold">Nouveau statut *</label>
                                <select name="statut_id" id="statut_id" class="form-select" required>
                                    <option value="">Sélectionner…</option>
                                    <?php foreach ($statuts as $s): ?>
                                        <option value="<?= $s['id'] ?>" <?= $s['id'] == $dossier['statut_id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($s['libelle']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>

                        <div class="mb-4">
                            <label for="commentaire_interne" class="form-label fw-semibold">Commentaire interne</label>
                            <small class="text-muted d-block mb-2">Visible uniquement par les gestionnaires</small>
                            <textarea name="commentaire_interne" id="commentaire_interne" class="form-control" rows="4" 
                                      placeholder="Ajoutez vos notes internes sur le traitement de ce dossier..."><?= htmlspecialchars($dossier['commentaire_interne'] ?? '') ?></textarea>
                        </div>

                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="auteur_notifie" id="auteur_notifie" 
                                       value="1" <?= $dossier['auteur_notifie'] ? 'checked' : '' ?>>
                                <label class="form-check-label fw-semibold" for="auteur_notifie">
                                    Auteur notifié
                                </label>
                                <small class="text-muted d-block">Cocher si l'auteur du dossier a été informé du traitement</small>
                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle me-1"></i>Mettre à jour le dossier
                            </button>
                            <a href="dashboard.php" class="btn btn-secondary">Annuler</a>
                        </div>
                    </form>
                </div>
            </div>

            <!-- 🔍 Section Pièces jointes -->
            <?php if (count($pieces_jointes) > 0): ?>
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-paperclip me-2"></i>Pièces jointes
                        <span class="badge bg-primary ms-2"><?= count($pieces_jointes) ?></span>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <?php foreach ($pieces_jointes as $piece): ?>
                            <?php 
                                // 🔍 CORRECTION : Obtenir le chemin corrigé
                                $chemin_corrige = getCheminPieceJointe($piece['chemin_stockage']);
                            ?>
                            <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-file-earmark me-3 text-muted fs-4"></i>
                                    <div>
                                        <div class="fw-semibold"><?= htmlspecialchars($piece['nom_fichier']) ?></div>
                                        <small class="text-muted">
                                            <?= formatTailleFichier($piece['taille']) ?> • 
                                            Uploadé le <?= (new DateTime($piece['date_upload']))->format('d/m/Y à H:i') ?>
                                        </small>
                                    </div>
                                </div>
                                <div class="btn-group">
                                    <a href="<?= htmlspecialchars($chemin_corrige) ?>" 
                                       class="btn btn-outline-primary btn-sm" 
                                       target="_blank"
                                       title="Voir la pièce jointe">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="<?= htmlspecialchars($chemin_corrige) ?>" 
                                       class="btn btn-outline-success btn-sm" 
                                       download="<?= htmlspecialchars($piece['nom_fichier']) ?>"
                                       title="Télécharger">
                                        <i class="bi bi-download"></i>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Colonne latérale - Informations du dossier -->
        <div class="col-lg-4">
            <!-- Informations générales -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">Informations du dossier</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted d-block">Titre</small>
                        <div class="fw-semibold"><?= htmlspecialchars($dossier['titre']) ?></div>
                    </div>
                    
                    <?php if (!empty($dossier['situation_libelle'])): ?>
                    <div class="mb-3">
                        <small class="text-muted d-block">Catégorie/Situation</small>
                        <div class="fw-semibold"><?= htmlspecialchars($dossier['situation_libelle']) ?></div>
                    </div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <small class="text-muted d-block">Service cible</small>
                        <div class="fw-semibold"><?= htmlspecialchars($dossier['nom_service']) ?></div>
                    </div>

                    <?php if (!empty($dossier['lieu'])): ?>
                    <div class="mb-3">
                        <small class="text-muted d-block">Lieu</small>
                        <div class="fw-semibold"><?= htmlspecialchars($dossier['lieu']) ?></div>
                    </div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <small class="text-muted d-block">Date de création</small>
                        <div class="fw-semibold"><?= (new DateTime($dossier['date_creation']))->format('d/m/Y à H:i') ?></div>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted d-block">Dernière modification</small>
                        <div class="fw-semibold"><?= (new DateTime($dossier['date_maj']))->format('d/m/Y à H:i') ?></div>
                    </div>

                    <!-- 🔍 Info pièces jointes dans la sidebar -->
                    <?php if (count($pieces_jointes) > 0): ?>
                    <div class="mb-3">
                        <small class="text-muted d-block">Pièces jointes</small>
                        <div class="fw-semibold text-success">
                            <i class="bi bi-paperclip me-1"></i><?= count($pieces_jointes) ?> fichier(s)
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Informations auteur (si mode confidentiel) -->
            <?php if ($dossier['mode_depot'] === 'confidentiel'): ?>
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">Informations de l'auteur</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted d-block">Nom</small>
                        <div class="fw-semibold"><?= htmlspecialchars($dossier['nom_auteur']) ?></div>
                    </div>

                    <?php if (!empty($dossier['matricule_auteur'])): ?>
                    <div class="mb-3">
                        <small class="text-muted d-block">Matricule</small>
                        <div class="fw-semibold"><?= htmlspecialchars($dossier['matricule_auteur']) ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if (!empty($dossier['service_auteur'])): ?>
                    <div class="mb-3">
                        <small class="text-muted d-block">Service</small>
                        <div class="fw-semibold"><?= htmlspecialchars($dossier['service_auteur']) ?></div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Description du dossier -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">Description du signalement/suggestion</h6>
                </div>
                <div class="card-body">
                    <div class="bg-light p-3 rounded">
                        <?= nl2br(htmlspecialchars($dossier['description'])) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Inclure le footer -->
<?php include 'admin_footer.php'; ?>