// public/assets/js/main.js
document.addEventListener('DOMContentLoaded', function () {
  // Sélectionne tous les boutons avec la classe .btn-action
  const buttons = document.querySelectorAll('.btn-action');

  buttons.forEach(btn => {
    btn.addEventListener('click', function (e) {
      // 1. Créer un span pour l'effet ripple
      const ripple = document.createElement('span');
      
      // 2. Calculer la taille du cercle
      const diameter = Math.max(btn.clientWidth, btn.clientHeight);
      const radius = diameter / 2;

      // 3. Appliquer les styles nécessaires
      ripple.style.width = ripple.style.height = `${diameter}px`;
      ripple.style.position = 'absolute';
      ripple.style.borderRadius = '50%';
      ripple.style.backgroundColor = 'rgba(255, 255, 255, 0.6)';
      ripple.style.transform = 'scale(0)';
      ripple.style.opacity = '1';
      ripple.style.left = `${e.clientX - this.getBoundingClientRect().left - radius}px`;
      ripple.style.top = `${e.clientY - this.getBoundingClientRect().top - radius}px`;
      ripple.style.pointerEvents = 'none'; // Ne pas interférer avec les clics
      ripple.style.overflow = 'hidden';
      ripple.classList.add('ripple');

      // 4. Supprimer un ancien ripple s'il existe
      const oldRipple = this.querySelector('.ripple');
      if (oldRipple) oldRipple.remove();

      // 5. Ajouter le nouveau ripple
      this.appendChild(ripple);

      // 6. Animation : agrandir et disparaître
      setTimeout(() => {
        ripple.style.transition = 'transform 0.6s ease, opacity 0.6s ease';
        ripple.style.transform = 'scale(4)';
        ripple.style.opacity = '0';
      }, 10);

      // 7. Supprimer le DOM après animation
      setTimeout(() => {
        if (ripple.parentNode === this) {
          ripple.remove();
        }
      }, 650);
    });
  });
});