<?php

require_once '../src/includes/config.php';


if (!defined('ASSETS_URL')) {
    die('Erreur : ASSETS_URL n\'est pas définie. Vérifiez config.php');
}
?>


<?php include 'header.php'; ?>

<div class="container py-5">
  <section class="hero animate__animated animate__fadeIn">
    <div class="hero-content">
      <h1 class="animate__animated animate__fadeInDown animate__delay-1s">Parole Libre</h1>
      <p class="lead animate__animated animate__fadeInUp animate__delay-2s">Votre voix compte. En toute confidentialité.</p>
    </div>
  </section>

  <div class="row justify-content-center g-4">
    <div class="col-md-5 col-lg-4">
      <div class="card animate__animated animate__fadeInUp animate__delay-1s text-center p-4">
        <div class="icon-circle icon-orange mb-3">⚠️</div>
        <h3>Signaler un fait non éthique</h3>
        <p>Anonyme • Confidentiel • Sécurisé</p>
        <a href="signalement.php" class="btn btn-orange btn-action">Déposer un signalement</a>
      </div>
    </div>

    <div class="col-md-5 col-lg-4">
      <div class="card animate__animated animate__fadeInUp animate__delay-2s text-center p-4">
        <div class="icon-circle icon-green mb-3">💡</div>
        <h3>Proposer une suggestion</h3>
        <p>Améliorez nos processus, services ou conditions de travail</p>
        <a href="suggestion.php" class="btn btn-green btn-action">Soumettre une idée</a>
      </div>
    </div>
  </div>

  <div class="text-center mt-4">
    <small>
      En utilisant cette plateforme, vous acceptez notre 
      <a href="#" data-bs-toggle="modal" data-bs-target="#modalPolitique">Politique de Confidentialité</a>.
    </small>
  </div>
</div>


<?php include 'footer.php'; ?>