markdown
# 📋 Parole Libre - Documentation Technique

## 🎯 Présentation Générale

**Nom de l'application :** Parole Libre  
**Objectif :** Plateforme sécurisée de signalement éthique et de suggestions pour Côte d'Ivoire Énergies  
**Version :** 1.0.0  
**Statut :** 🔥 Production  

### 🛠 Stack Technique
- **Backend :** PHP 8.1+
- **Frontend :** HTML5, CSS3, Bootstrap 5, JavaScript Vanilla
- **Base de données :** MySQL 8.0+
- **Serveur Web :** Apache 2.4+ / Nginx
- **Sécurité :** HTTPS obligatoire, PDO préparé, chiffrement SHA-256

### 📜 Conformité
- ✅ Loi n° 2013-450 du 19 juin 2013 sur la protection des données
- ✅ Principes RGPD appliqués
- ✅ Conservation des données selon politique de confidentialité

---

## 📁 Structure du Projet
TrustLine/
├── 📂 public/ # Racine web accessible
│ ├── 🎯 index.php # Page d'accueil
│ ├── 📝 signalement.php # Formulaire signalement éthique
│ ├── 💡 suggestion.php # Formulaire suggestions
│ ├── 🔍 suivi.php # Suivi des dossiers
│ ├── 🙏 merci.php # Page de confirmation
│ ├── 💾 save_signalement.php # Traitement signalements
│ ├── 💾 save_suggestion.php # Traitement suggestions
│ ├── 📂 assets/ # Ressources statiques
│ │ ├── 🎨 css/ # Feuilles de style
│ │ ├── ⚡ js/ # Scripts JavaScript
│ │ └── 🖼️ img/ # Images et icônes
│ ├── 📂 uploads/ # Fichiers joints (sécurisé)
│ └── 📂 admin/ # Espace administrateur
│ ├── 🔐 login.php # Authentification
│ ├── 📊 dashboard.php # Tableau de bord
│ ├── ✏️ traitement.php # Gestion des dossiers
│ └── 📈 rapport.php # Rapports et statistiques
├── 📂 src/
│ └── 📂 includes/
│ ├── ⚙️ config.php # Configuration et sessions
│ └── 🗄️ db.php # Connexion base de données
├── 📂 docs/ # Documentation publique
├── 📂 lib/ # Librairies externes
└── 📖 README.md # Documentation principale

text

---

## 🛡️ Sécurité & Conformité

### 🔒 Anonymat Garanti
- 🚫 Aucune IP, cookie ou session logguée pour les dépôts anonymes
- 🚫 Pas de champ d'identité dans les formulaires anonymes
- 🔐 Fichiers renommés et stockés avec hash SHA-256

### 🛡️ Sécurité des Données
- 🛡️ Toutes les requêtes SQL utilisent PDO préparé
- 📁 Uploads filtrés par extension et taille (max 20 Mo)
- 📂 Fichiers stockés avec accès restreint
- 🔐 Sessions sécurisées via `session_status()`

### 📜 Conformité RGPD
- 📋 Respect de la loi 2013-450
- ⏱️ Conservation limitée selon politique
- 🕵️ Pas de traçabilité possible pour les utilisateurs anonymes

---

## 🗃️ Modèle de Données

### 📊 Tables Principales

#### `dossiers` - Gestion des signalements/suggestions
| Champ | Type | Description |
|-------|------|-------------|
| `id` | INT | Identifiant unique |
| `numero_dossier` | VARCHAR(20) | Numéro unique (ex: CI-ETH-XXXXXX) |
| `type_id` | INT | Type (signalement/suggestion) |
| `type_situation_id` | INT | Catégorie spécifique |
| `titre` | TEXT | Titre du dossier |
| `description` | TEXT | Description détaillée |
| `mode_depot` | ENUM | 'anonyme' ou 'confidentiel' |
| `service_cible_id` | INT | Service responsable |
| `statut_id` | INT | État du dossier |
| `date_creation` | DATETIME | Date de création |
| `date_maj` | DATETIME | Dernière modification |

#### `pieces_jointes` - Fichiers associés
| Champ | Type | Description |
|-------|------|-------------|
| `id` | INT | Identifiant unique |
| `dossier_id` | INT | Lien vers le dossier |
| `nom_fichier` | VARCHAR(255) | Nom original |
| `chemin_stockage` | VARCHAR(500) | Chemin sécurisé |
| `taille` | INT | Taille en octets |
| `hash_sha256` | CHAR(64) | Empreinte de sécurité |

#### `gestionnaires` - Accès administrateur
| Champ | Type | Description |
|-------|------|-------------|
| `id` | INT | Identifiant unique |
| `nom_complet` | VARCHAR(100) | Nom du gestionnaire |
| `email` | VARCHAR(100) | Email (unique) |
| `mot_de_passe` | TEXT | Mot de passe haché |
| `service_id` | INT | Service associé |
| `role` | ENUM | 'admin' ou 'gestionnaire' |
| `actif` | BOOLEAN | Statut du compte |

#### `services` - Services de l'entreprise
| Champ | Type | Description |
|-------|------|-------------|
| `id` | INT | Identifiant unique |
| `nom_service` | VARCHAR(100) | Nom du service |
| `email_alerte` | VARCHAR(100) | Email pour notifications |

#### `statuts` - États des dossiers
| Champ | Type | Description |
|-------|------|-------------|
| `id` | INT | Identifiant unique |
| `libelle` | VARCHAR(50) | Libellé du statut |

#### `types_dossier` - Types de dépôt
| Champ | Type | Description |
|-------|------|-------------|
| `id` | INT | Identifiant unique |
| `libelle` | VARCHAR(50) | Type (Signalement éthique, Suggestion) |

#### `types_situation` - Catégories spécifiques
| Champ | Type | Description |
|-------|------|-------------|
| `id` | INT | Identifiant unique |
| `libelle` | VARCHAR(255) | Libellé de la situation |
| `code` | VARCHAR(64) | Code unique |
| `dossier_type_id` | INT | Type de dossier associé |
| `actif` | BOOLEAN | Statut actif |

#### `consentements` - Traçabilité des consentements
| Champ | Type | Description |
|-------|------|-------------|
| `id` | INT | Identifiant unique |
| `dossier_id` | INT | Lien vers le dossier |
| `ip_utilisateur` | VARCHAR(45) | IP de dépôt |
| `user_agent` | TEXT | Navigateur utilisé |
| `date_consentement` | DATETIME | Date du consentement |
| `accepte_transfert_etranger` | BOOLEAN | Acceptation transfert |

### 🔗 Relations
dossiers → types_dossier (type_id)
dossiers → types_situation (type_situation_id)
dossiers → services (service_cible_id)
dossiers → statuts (statut_id)
pieces_jointes → dossiers (dossier_id)
gestionnaires → services (service_id)
consentements → dossiers (dossier_id)
types_situation → types_dossier (dossier_type_id)

text

---

## 🚀 Installation & Déploiement

### 📥 Installation Locale (Développement)

1. **Cloner le projet**
   ```bash
   git clone https://github.com/votre-compte/trustline.git
   cd TrustLine
Configurer la base de données

bash
mysql -u root -p cie_integrity_db < BD-CI-E.sql
Configurer l'environnement

php
// src/includes/db.php
$host = 'localhost';
$dbname = 'cie_integrity_db';
$username = 'root';
$password = '';
Démarrer le serveur

bash
cd public
php -S localhost:8000
Accéder à l'application

🌐 Interface publique : http://localhost:8000

🔐 Espace admin : http://localhost:8000/admin/login.php

🔧 Comptes par Défaut
Admin : admin@civenergie.ci / password

Gestionnaire : modeste.lalie@gmail.com / password

🛠 Maintenance
💾 Sauvegarde
bash
# Sauvegarde quotidienne de la base
mysqldump -u root -p cie_integrity_db > backup-$(date +%F).sql

# Compression automatique
gzip backup-$(date +%F).sql
📊 Monitoring
bash
# Vérification des logs
tail -f /var/log/apache2/error.log

# Surveillance des uploads
du -sh public/uploads/
find public/uploads/ -type f -mtime +30 -delete
🔄 Mises à Jour
bash
# Mise à jour du code
git pull origin main

# Mise à jour base de données
mysql -u root -p cie_integrity_db < migrations/migration_vX.X.sql
🔐 Permissions
bash
# Sécurisation des dossiers
chmod -R 755 public/uploads/
chown -R www-data:www-data public/uploads/
📈 Fonctionnalités Avancées
🔍 Tableau de Bord Admin
📊 Statistiques en temps réel

📋 Pagination des dossiers (10/page)

📎 Indicateur pièces jointes

🎯 Filtrage par service et statut

📁 Gestion des Pièces Jointes
✅ Support multi-format (PDF, images, documents)

🔒 Renommage sécurisé avec hash

📏 Limite de taille : 20 Mo par fichier

🔍 Prévisualisation et téléchargement

🔔 Notifications
📧 Alertes par email aux services

🔄 Mise à jour automatique des statuts

📱 Interface responsive

🔄 Workflow des Dossiers
📥 Dépôt Utilisateur
Choix du type (Signalement/Suggestion)

Sélection de la catégorie spécifique

Rédaction du contenu

Upload facultatif de pièces jointes

Génération automatique du numéro de dossier

Consentement RGPD

🛠️ Traitement Admin
Réception : Dossier marqué "Reçu"

Analyse : Passage en "En cours d'analyse"

Traitement : Commentaires internes, notification auteur

Clôture : "Action entreprise" ou "Non retenu"

🔢 Numérotation Automatique
text
CI-ETH-XXXXXX : Signalement Éthique
CI-SUG-XXXXXX : Suggestion
🐛 Dépannage
Problèmes Courants
Erreur de connexion base de données

php
// Vérifier src/includes/db.php
$pdo = new PDO("mysql:host=localhost;dbname=cie_integrity_db", $username, $password);
Fichiers joints non accessibles

bash
# Vérifier les permissions
chmod 755 public/uploads/
chmod 644 public/uploads/*/*
Problème de pagination

sql
-- Vérifier la requête avec LIMIT et OFFSET
SELECT ... LIMIT 10 OFFSET 0
Erreur ONLY_FULL_GROUP_BY

sql
-- Utiliser des sous-requêtes au lieu de GROUP BY
(SELECT COUNT(*) FROM pieces_jointes WHERE dossier_id = d.id) AS nb_pieces
📊 Requêtes SQL Importantes
Récupération des dossiers avec pagination :

sql
SELECT d.*, tt.libelle AS type_libelle, ts.libelle AS situation_libelle,
       st.libelle AS statut_libelle, s.nom_service AS service_cible_nom,
       (SELECT COUNT(*) FROM pieces_jointes pj WHERE pj.dossier_id = d.id) AS nb_pieces_jointes
FROM dossiers d
JOIN types_dossier tt ON d.type_id = tt.id
LEFT JOIN types_situation ts ON d.type_situation_id = ts.id
JOIN statuts st ON d.statut_id = st.id
LEFT JOIN services s ON d.service_cible_id = s.id
WHERE d.service_cible_id IN (1, 2)
ORDER BY d.date_creation DESC
LIMIT 10 OFFSET 0
Statistiques des dossiers :

sql
SELECT 
    COUNT(*) as total,
    SUM(CASE WHEN statut_id = 1 THEN 1 ELSE 0 END) as attente,
    SUM(CASE WHEN statut_id = 2 THEN 1 ELSE 0 END) as en_cours,
    SUM(CASE WHEN statut_id IN (4,5) THEN 1 ELSE 0 END) as clotures
FROM dossiers
WHERE service_cible_id IN (1, 2)
🔧 API Interne
Endpoints Principaux
Dashboard Statistics

php
// dashboard.php
$services_autorises = ($role === 'admin') ? [1, 2] : [$service_id];
$stmt = $pdo->prepare("SELECT ... WHERE service_cible_id IN (...)");
Traitement Dossier

php
// traitement.php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nouveau_statut = $_POST['statut_id'];
    $commentaire_interne = $_POST['commentaire_interne'];
    // Mise à jour du dossier...
}
Gestion Pièces Jointes

php
// Fonction de correction de chemin
function getCheminPieceJointe($chemin_stockage) {
    if (strpos($chemin_stockage, 'uploads/') === 0) {
        return '../../' . $chemin_stockage;
    }
    return $chemin_stockage;
}

Support Technique

Contact Développeur
📧 modeste.lalie@gmail.com
📞 +225 0708161625

Documentation Associée

📖 Guide d'utilisation utilisateur

🛠 API Documentation

🔒 Politique de sécurité

📋 Procédures de maintenance

Support en Ligne

🐛 Suivi des bugs

📚 Wiki technique

🔄 Changelog

🔄 Versions
Version	Date	Description
1.0.0	2024-10-10	Version initiale - Signalements et suggestions
1.1.0	À venir	Export PDF, notifications avancées
1.2.0	À venir	API REST, intégration SSO

📝 Journal des Modifications

    Version 1.0.0 (Octobre 2024)
    Implémentation complète des signalements éthiques
    Système de suggestions
    Interface d'administration
    Gestion des pièces jointes
    Pagination et recherche
    Conformité RGPD

<div align="center">
🚀 Développé avec soin pour Côte d'Ivoire Énergies
Sécurité • Confidentialité • Performance

© 2025 Côte d'Ivoire Énergies - Tous droits réservés