<!-- public/admin/admin_header.php -->
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Admin — Parole Libre</title>

  <!-- Bootstrap 5.3.3 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
    integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
    crossorigin="anonymous"
  />

  <!-- Icônes Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet" />

  <!-- CSS personnalisé -->
  <link href="assets/css/admin-layout.css" rel="stylesheet" />
</head>
<body>
  <!-- Ligne d'accentuation colorée -->
  <div class="topbar-accent"></div>

  <!-- Header principal - SANS LOGO, CONTENU CENTRÉ -->
  <nav class="navbar navbar-expand-lg navbar-branding fixed-top">
    <div class="container-fluid justify-content-center">
      <!-- Contenu centré -->
      <div class="d-flex align-items-center header-centered-content">
        <!-- Nom de l'application -->
        <h1 class="app-name-main mb-0 me-4">Parole Libre</h1>
        
        <!-- Recherche centrée -->
        <div class="header-search">
          <i class="bi bi-search"></i>
          <input type="search" class="form-control" placeholder="Rechercher un dossier, utilisateur..." aria-label="Search">
        </div>
      </div>

      <!-- Bouton toggle sidebar mobile -->
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent">
        <span class="navbar-toggler-icon"></span>
      </button>

      <!-- Menu utilisateur à droite -->
      <div class="collapse navbar-collapse flex-grow-0" id="navbarSupportedContent">
        <ul class="navbar-nav align-items-center">
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" role="button" data-bs-toggle="dropdown">
              <div class="avatar-placeholder me-2">
                <i class="bi bi-person"></i>
              </div>
              <span class="user-name"><?= htmlspecialchars($_SESSION['nom_complet'] ?? 'Utilisateur') ?></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
              <li><a class="dropdown-item" href="#"><i class="bi bi-person me-2"></i>Profil</a></li>
              <li><a class="dropdown-item" href="#"><i class="bi bi-gear me-2"></i>Paramètres</a></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Déconnexion</a></li>
            </ul>
          </li>
        </ul>
      </div>
    </div>
  </nav>

  <!-- Sidebar - SANS TEXTE "PAROLE LIBRE" -->
  <aside class="sidebar">
    <!-- Logo sidebar seulement -->
    <div class="brand-pane">
      <img src="assets/img/logo-ci-energies.png" alt="Côte d'Ivoire Énergies">
    </div>

    <!-- Menu navigation -->
    <div class="menu">
      <div class="menu-title">Navigation</div>
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>" href="dashboard.php">
            <i class="bi bi-speedometer2"></i>
            <span>Tableau de bord</span>
          </a>
        </li>

        <li class="nav-item">
          <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'stats.php' ? 'active' : '' ?>" href="stats.php">
            <i class="bi bi-bar-chart-line"></i>
            <span>Statistiques</span>
          </a>
        </li>

        <div class="menu-title">Rapports</div>
        
        <li class="nav-item">
          <a class="nav-link" href="rapport.php" target="_blank">
            <i class="bi bi-file-pdf"></i>
            <span>Exporter PDF</span>
          </a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="export.php">
            <i class="bi bi-file-earmark-excel"></i>
            <span>Exporter Excel</span>
          </a>
        </li>

        <div class="menu-title">Administration</div>
        
        <li class="nav-item">
          <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'utilisateurs.php' ? 'active' : '' ?>" href="utilisateurs.php">
            <i class="bi bi-people"></i>
            <span>Utilisateurs</span>
          </a>
          <a href="documentation.php" class="btn btn-outline-secondary btn-sm">
                        <i class="bi bi-file-text me-1"></i>Documentation technique
                    </a>
        </li>

        
      </ul>
    </div>
  </aside>

  <!-- Wrapper principal -->
  <div class="app-wrapper">
    <div class="container-fluid p-4">