<?php
// documentation.php
require_once __DIR__ . '/../../src/includes/config.php';

if (!isset($_SESSION['gestionnaire_id'])) {
    header('Location: login.php');
    exit;
}

$doc_file = __DIR__ . '/README-TECHNIQUE.md';
$doc_exists = file_exists($doc_file);
$doc_size = $doc_exists ? filesize($doc_file) : 0;
$doc_date = $doc_exists ? date('d/m/Y à H:i', filemtime($doc_file)) : 'Non disponible';

if ($doc_exists) {
    $content = file_get_contents($doc_file);
    $doc_content = formatMarkdown($content);
}

function formatMarkdown($content) {
    // Titres
    $content = preg_replace('/^# (.*$)/m', '<h1 class="doc-h1">$1</h1>', $content);
    $content = preg_replace('/^## (.*$)/m', '<h2 class="doc-h2">$1</h2>', $content);
    $content = preg_replace('/^### (.*$)/m', '<h3 class="doc-h3">$1</h3>', $content);
    
    // Listes
    $content = preg_replace('/^- (.*$)/m', '<li>$1</li>', $content);
    $content = preg_replace('/(<li>.*<\/li>)/s', '<ul class="doc-ul">$1</ul>', $content);
    
    // Code
    $content = preg_replace('/```(\w+)?\n(.*?)\n```/s', '<pre class="doc-pre"><code>$2</code></pre>', $content);
    $content = preg_replace('/`(.*?)`/', '<code class="doc-code">$1</code>', $content);
    
    // Tableaux
    $content = preg_replace('/\|(.*)\|/m', '<table class="doc-table"><tr><td>$1</td></tr></table>', $content);
    $content = str_replace('|', '</td><td>', $content);
    
    // Séparateurs
    $content = preg_replace('/---+/', '<hr class="doc-hr">', $content);
    
    return nl2br($content);
}
?>

<?php include 'admin_header.php'; ?>

<div class="container-fluid p-4">
    <!-- Header simple -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1 text-dark">Documentation Technique</h1>
            <p class="text-muted mb-0">Parole Libre - Plateforme de signalement éthique</p>
        </div>
        <div class="d-flex gap-2">
            <a href="dashboard.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-1"></i>Retour
            </a>
            <?php if ($doc_exists): ?>
            <a href="README-TECHNIQUE.md" download class="btn btn-primary">
                <i class="bi bi-download me-1"></i>Télécharger
            </a>
            <?php endif; ?>
        </div>
    </div>

    <!-- Métadonnées discrètes -->
    <?php if ($doc_exists): ?>
    <div class="alert alert-light border mb-4">
        <div class="d-flex justify-content-between align-items-center text-muted small">
            <span><i class="bi bi-info-circle me-1"></i> Dernière mise à jour : <?= $doc_date ?></span>
            <span><i class="bi bi-file-text me-1"></i> <?= round($doc_size / 1024, 2) ?> Ko</span>
            <span><i class="bi bi-tag me-1"></i> Version 1.0.0</span>
        </div>
    </div>
    <?php endif; ?>

    <div class="row">
        <!-- Contenu principal -->
        <div class="col-12">
            <?php if ($doc_exists): ?>
            
            <!-- Documentation -->
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4 documentation-content">
                    <?= $doc_content ?>
                </div>
            </div>

            <!-- Footer simple -->
            <div class="text-center mt-4 text-muted small">
                <p>Documentation technique Parole Libre • © 2024 Côte d'Ivoire Énergies</p>
            </div>

            <?php else: ?>
            
            <!-- État vide -->
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center py-5">
                    <i class="bi bi-file-earmark-x fs-1 text-muted mb-3"></i>
                    <h4 class="text-muted">Documentation non disponible</h4>
                    <p class="text-muted mb-4">Le fichier README-TECHNIQUE.md est introuvable.</p>
                    <a href="dashboard.php" class="btn btn-primary">
                        <i class="bi bi-arrow-left me-2"></i>Retour au tableau de bord
                    </a>
                </div>
            </div>

            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.documentation-content {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', system-ui, sans-serif;
    line-height: 1.6;
    color: #374151;
    font-size: 1rem;
}

/* Titres */
.documentation-content .doc-h1 {
    color: #1f2937;
    font-weight: 600;
    font-size: 1.75rem;
    margin: 2rem 0 1rem 0;
    padding-bottom: 0.5rem;
    border-bottom: 2px solid #3b82f6;
}

.documentation-content .doc-h2 {
    color: #374151;
    font-weight: 600;
    font-size: 1.5rem;
    margin: 1.5rem 0 1rem 0;
}

.documentation-content .doc-h3 {
    color: #6b7280;
    font-weight: 600;
    font-size: 1.25rem;
    margin: 1.25rem 0 0.75rem 0;
}

/* Paragraphes */
.documentation-content p {
    margin-bottom: 1rem;
    color: #4b5563;
}

/* Listes */
.documentation-content .doc-ul {
    margin: 1rem 0;
    padding-left: 1.5rem;
}

.documentation-content li {
    margin-bottom: 0.5rem;
    position: relative;
}

.documentation-content li:before {
    content: "•";
    color: #3b82f6;
    position: absolute;
    left: -1rem;
}

/* Code */
.documentation-content .doc-pre {
    background: #1f2937;
    color: #f3f4f6;
    padding: 1.5rem;
    border-radius: 8px;
    margin: 1rem 0;
    overflow-x: auto;
    font-family: 'Monaco', 'Menlo', monospace;
    font-size: 0.9rem;
    line-height: 1.5;
}

.documentation-content .doc-code {
    background: #f3f4f6;
    color: #dc2626;
    padding: 0.2rem 0.4rem;
    border-radius: 4px;
    font-family: 'Monaco', 'Menlo', monospace;
    font-size: 0.875rem;
}

/* Tableaux */
.documentation-content .doc-table {
    width: 100%;
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    border-collapse: collapse;
    margin: 1rem 0;
}

.documentation-content .doc-table th {
    background: #3b82f6;
    color: white;
    padding: 0.75rem 1rem;
    text-align: left;
    font-weight: 600;
}

.documentation-content .doc-table td {
    padding: 0.75rem 1rem;
    border-bottom: 1px solid #e5e7eb;
}

.documentation-content .doc-table tr:nth-child(even) {
    background: #f9fafb;
}

/* Séparateurs */
.documentation-content .doc-hr {
    margin: 2rem 0;
    border: none;
    border-top: 1px solid #e5e7eb;
}

/* Responsive */
@media (max-width: 768px) {
    .documentation-content {
        padding: 1rem !important;
        font-size: 0.95rem;
    }
    
    .documentation-content .doc-h1 {
        font-size: 1.5rem;
    }
    
    .documentation-content .doc-h2 {
        font-size: 1.35rem;
    }
    
    .documentation-content .doc-h3 {
        font-size: 1.15rem;
    }
    
    .documentation-content .doc-pre {
        padding: 1rem;
        font-size: 0.85rem;
    }
}
</style>

<?php include 'admin_footer.php'; ?>