<?php
// src/includes/config.php

// Démarrer la session seulement si elle n'est pas déjà active
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Définir les chemins
define('ROOT', dirname(__DIR__, 2));
define('ASSETS_URL', '/trustline/public/assets');

// Connexion à la base de données
require_once 'db.php';

// Fonction de génération du numéro de dossier
function genererNumeroDossier($type) {
    $prefix = ($type === 'ethique') ? 'CI-ETH-' : 'CI-SUG-';
    return $prefix . strtoupper(substr(uniqid(), -6));
}
?>