<!-- footer.php -->
<?php
// On retire $base_url car inutile ici
// Le serveur expose 'public/' comme racine web
?>

<!-- Footer moderne -->
<footer class="footer mt-auto bg-dark text-white position-relative">
  <!-- Vague décorative -->
  <div class="wave-divider">
    <svg viewBox="0 0 1200 120" preserveAspectRatio="none">
      <path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z" 
            fill="currentColor"></path>
    </svg>
  </div>

  <div class="container py-5">
    <div class="row g-4">
      <!-- Logo et description -->
      <div class="col-lg-4 col-md-6">
        <div class="footer-brand mb-4">
          <img src="assets/img/logo-ci-energies.png" alt="Côte d'Ivoire Énergies" height="50" class="mb-3">
          <p class="text-light opacity-75">
            Votre partenaire énergétique de confiance. Ensemble, construisons un avenir énergétique durable pour la Côte d'Ivoire.
          </p>
        </div>
        <div class="social-links">
          <a href="#" class="social-link">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a href="#" class="social-link">
            <i class="fab fa-twitter"></i>
          </a>
          <a href="#" class="social-link">
            <i class="fab fa-linkedin-in"></i>
          </a>
          <a href="#" class="social-link">
            <i class="fab fa-instagram"></i>
          </a>
        </div>
      </div>

      <!-- Liens rapides -->
      <div class="col-lg-2 col-md-6">
        <h5 class="footer-title">Navigation</h5>
        <ul class="footer-links list-unstyled">
          <li><a href="index.php" class="footer-link">Accueil</a></li>
          <li><a href="signalement.php" class="footer-link">Signalement</a></li>
          <li><a href="suggestion.php" class="footer-link">Suggestion</a></li>
        </ul>
      </div>

      <!-- Liens légaux -->
      <div class="col-lg-3 col-md-6">
        <h5 class="footer-title">Légal</h5>
        <ul class="footer-links list-unstyled">
          <li><a href="#" class="footer-link" data-bs-toggle="modal" data-bs-target="#modalPolitique">Politique de confidentialité</a></li>
          <li><a href="#" class="footer-link">Mentions légales</a></li>
          <li><a href="#" class="footer-link">Conditions d'utilisation</a></li>
        </ul>
      </div>

      <!-- Contact -->
      <div class="col-lg-3 col-md-6">
        <h5 class="footer-title">Contact</h5>
        <div class="contact-info">
          <div class="contact-item mb-2">
            <i class="fas fa-phone me-2 text-orange"></i>
            <span class="text-light opacity-75">+225 27 20 30 40 50</span>
          </div>
          <div class="contact-item mb-2">
            <i class="fas fa-envelope me-2 text-orange"></i>
            <span class="text-light opacity-75">contact@ci-energies.ci</span>
          </div>
          <div class="contact-item mb-2">
            <i class="fas fa-map-marker-alt me-2 text-orange"></i>
            <span class="text-light opacity-75">Abidjan, Côte d'Ivoire</span>
          </div>
        </div>
      </div>
    </div>

    <hr class="my-4 border-light opacity-25">

    <!-- Copyright et lien admin -->
    <div class="row align-items-center">
      <div class="col-md-6 text-center text-md-start">
        <p class="text-light opacity-75 mb-0">
          © <?= date('Y') ?> Côte d'Ivoire Énergies — Tous droits réservés.
        </p>
      </div>
      <div class="col-md-6 text-center text-md-end">
        <a href="/admin/login.php" class="admin-link" title="Accès administrateur">
          <i class="fas fa-shield-alt me-1"></i>
          <span>Espace administrateur</span>
        </a>
      </div>
    </div>
  </div>
</footer>

<!-- Styles du footer -->
<style>
  .footer {
    background: linear-gradient(135deg, var(--ci-dark) 0%, #1a1a1a 100%);
    position: relative;
    overflow: hidden;
  }

  .wave-divider {
    position: absolute;
    top: -2px;
    left: 0;
    width: 100%;
    line-height: 0;
    color: var(--ci-light);
  }

  .wave-divider svg {
    width: 100%;
    height: 60px;
  }

  .footer-title {
    color: white;
    font-weight: 600;
    margin-bottom: 1rem;
    position: relative;
    padding-bottom: 0.5rem;
  }

  .footer-title::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 40px;
    height: 3px;
    background: var(--ci-gradient);
    border-radius: 2px;
  }

  .footer-links {
    line-height: 2.2;
  }

  .footer-link {
    color: rgba(255, 255, 255, 0.75) !important;
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
    padding-left: 0;
  }

  .footer-link::before {
    content: '▸';
    color: var(--ci-orange);
    position: absolute;
    left: -15px;
    opacity: 0;
    transition: all 0.3s ease;
  }

  .footer-link:hover {
    color: white !important;
    padding-left: 15px;
    transform: translateX(5px);
  }

  .footer-link:hover::before {
    opacity: 1;
    left: 0;
  }

  .social-links {
    display: flex;
    gap: 12px;
    margin-top: 1.5rem;
  }

  .social-link {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
    color: white;
    text-decoration: none;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
  }

  .social-link:hover {
    background: var(--ci-gradient);
    transform: translateY(-3px) scale(1.1);
    box-shadow: 0 5px 15px rgba(243, 111, 33, 0.3);
  }

  .contact-item {
    display: flex;
    align-items: center;
  }

  .text-orange {
    color: var(--ci-orange) !important;
  }

  .admin-link {
    color: rgba(255, 255, 255, 0.6) !important;
    text-decoration: none;
    font-size: 0.9rem;
    transition: all 0.3s ease;
    padding: 8px 16px;
    border-radius: 6px;
    background: rgba(255, 255, 255, 0.05);
  }

  .admin-link:hover {
    color: white !important;
    background: rgba(255, 255, 255, 0.1);
    transform: translateY(-2px);
  }

  /* Modal amélioré */
  .modal-content {
    border: none;
    border-radius: 12px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
    overflow: hidden;
  }

  .modal-header {
    background: var(--ci-gradient);
    color: white;
    border-bottom: none;
    padding: 1.5rem;
  }

  .modal-title {
    font-weight: 600;
  }

  .btn-primary {
    background: var(--ci-gradient);
    border: none;
    border-radius: 8px;
    padding: 10px 25px;
    font-weight: 600;
    transition: all 0.3s ease;
  }

  .btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(243, 111, 33, 0.3);
  }

  .btn-outline-secondary {
    border-radius: 8px;
    padding: 10px 25px;
    transition: all 0.3s ease;
  }

  .btn-outline-secondary:hover {
    transform: translateY(-2px);
  }
</style>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" 
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" 
        crossorigin="anonymous" defer></script>

<!-- Script de raccourci clavier -->
<script>
document.addEventListener('keydown', function(e) {
  if (e.ctrlKey && e.altKey && e.key === 'A') {
    e.preventDefault();
    const modal = new bootstrap.Modal(document.getElementById('adminModal'));
    modal.show();
  }
});

// Animation au scroll
document.addEventListener('DOMContentLoaded', function() {
  const footer = document.querySelector('.footer');
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.style.opacity = "1";
        entry.target.style.transform = "translateY(0)";
      }
    });
  }, { threshold: 0.1 });

  footer.style.opacity = "0";
  footer.style.transform = "translateY(30px)";
  footer.style.transition = "all 0.6s ease-out";
  
  observer.observe(footer);
});
</script>

<!-- Modal de confirmation avant accès admin -->
<div class="modal fade" id="adminModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Accès Administrateur</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fermer"></button>
      </div>
      <div class="modal-body text-center py-4">
        <i class="fas fa-shield-alt fa-3x text-orange mb-3"></i>
        <p class="mb-0">Vous êtes sur le point d'accéder à l'espace administrateur sécurisé.</p>
      </div>
      <div class="modal-footer justify-content-center">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Annuler</button>
        <a href="/admin/login.php" class="btn btn-primary">
          <i class="fas fa-sign-in-alt me-2"></i>Se connecter
        </a>
      </div>
    </div>
  </div>
</div>

<!-- Modal Politique de Confidentialité -->
<div class="modal fade" id="modalPolitique" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Politique de Confidentialité</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <iframe 
          src="/docs/politique-confidentialite.pdf" 
          title="Politique de Confidentialité" 
          width="100%" 
          height="500" 
          style="border:none; border-radius: 8px;">
        </iframe>
      </div>
      <div class="modal-footer">
        <a href="/docs/politique-confidentialite.pdf" class="btn btn-outline-secondary" target="_blank">
          <i class="fas fa-download me-2"></i>Télécharger le PDF
        </a>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
      </div>
    </div>
  </div>
</div>

</body>
</html>