<!-- header.php -->
<?php
// Définit le chemin absolu basé sur la racine du site
$base_url = '/TrustLine'; // ⚠️ Adapte si ton projet est ailleurs
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Parole Libre – Côte d’Ivoire Énergies</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Animate.css -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

  <!-- Ton style -->
  <link rel="stylesheet" href="assets/css/style.css">

  <style>
    /* Animations personnalisées */
    @keyframes fadeSlideDown {
      from { opacity: 0; transform: translateY(-25px); }
      to { opacity: 1; transform: translateY(0); }
    }
    header {
      background: white;
      box-shadow: 0 4px 16px rgba(0,0,0,0.06);
      position: sticky;
      top: 0;
      z-index: 1000;
      animation: fadeSlideDown 0.8s ease forwards;
    }
    .navbar-brand img {
      transition: transform 0.4s ease;
    }
    .navbar-brand img:hover {
      transform: scale(1.08);
    }
    .nav-link {
      transition: color 0.3s ease;
    }
    .nav-link:hover {
      color: var(--ci-orange) !important;
    }
  </style>
</head>
<body>
  <header>
    <nav class="navbar navbar-expand-lg bg-white py-3">
      <div class="container">
        <a class="navbar-brand animate__animated animate__fadeInDown" href="index.php">
          <img src="assets/img/logo-ci-energies.png" alt="Logo" height="55">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse animate__animated animate__fadeInDown animate__delay-1s" id="navbarNav">
          <ul class="navbar-nav ms-auto">
            <li class="nav-item"><a class="nav-link fw-semibold text-dark px-3" href="index.php">Accueil</a></li>
            <li class="nav-item"><a class="nav-link fw-semibold text-dark px-3" href="signalement.php">Signalement</a></li>
            <li class="nav-item"><a class="nav-link fw-semibold text-dark px-3" href="suggestion.php">Suggestion</a></li>
            <li class="nav-item ms-lg-2">   <a class="btn btn-success px-3" href="suivi.php">🔍 Suivi</a> </li>
			
          </ul>
        </div>
      </div>
    </nav>
  </header>
