<?php
// merci.php
$numero = $_GET['numero'] ?? 'inconnu';
$type = $_GET['type'] ?? 'suggestion';

// Définir le message selon le type
$message = ($type === 'ethique') 
    ? "Votre signalement a été enregistré avec succès." 
    : "Votre suggestion a été soumise avec succès.";

$details = ($type === 'ethique')
    ? "Vous pouvez suivre son traitement à tout moment via ce numéro."
    : "Nous examinerons votre idée et vous informerons si elle est retenue.";

$icon = ($type === 'ethique') ? 'fa-shield-check' : 'fa-lightbulb';
$color = ($type === 'ethique') ? '#F36F21' : '#84BD00';
?>

<?php include 'header.php'; ?>

<style>
:root {
  --ci-orange: #F36F21;
  --ci-green: #84BD00;
  --ci-dark: #2C2C2C;
  --ci-light: #F8F9FA;
  --ci-border: #E1E5E9;
  --ci-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
  --ci-radius: 16px;
  --ci-transition: all 0.3s ease;
}

.success-container {
  min-height: 70vh;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 2rem 0;
}

.success-card {
  background: white;
  border-radius: var(--ci-radius);
  box-shadow: var(--ci-shadow);
  padding: 3rem 2rem;
  text-align: center;
  max-width: 600px;
  width: 100%;
  border: 1px solid var(--ci-border);
}

.success-icon {
  width: 100px;
  height: 100px;
  margin: 0 auto 2rem;
  background: linear-gradient(135deg, <?= $color ?> 0%, <?= $type === 'ethique' ? '#FF8C42' : '#A5D721' ?> 100%);
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
  animation: successPop 0.6s ease-out;
}

.success-icon::before {
  content: '';
  position: absolute;
  width: 120px;
  height: 120px;
  border-radius: 50%;
  background: <?= $color ?>20;
  animation: ripple 1.5s ease-out infinite;
}

.success-icon i {
  font-size: 2.5rem;
  color: white;
  position: relative;
  z-index: 2;
}

.success-title {
  font-size: 2.5rem;
  font-weight: 800;
  color: var(--ci-dark);
  margin-bottom: 1rem;
  line-height: 1.2;
}

.success-message {
  font-size: 1.25rem;
  color: #6c757d;
  margin-bottom: 1.5rem;
  line-height: 1.6;
}

.success-details {
  font-size: 1.1rem;
  color: var(--ci-dark);
  font-weight: 500;
  margin-bottom: 2.5rem;
  padding: 0 1rem;
}

.tracking-card {
  background: linear-gradient(135deg, #f8fff0 0%, #f0f9ff 100%);
  border: 2px dashed <?= $color ?>40;
  border-radius: var(--ci-radius);
  padding: 2rem;
  margin: 2rem 0;
}

.tracking-label {
  font-size: 1rem;
  color: #6c757d;
  margin-bottom: 1rem;
  font-weight: 600;
}

.tracking-number {
  font-size: 2.5rem;
  font-weight: 800;
  color: <?= $color ?>;
  font-family: 'Courier New', monospace;
  letter-spacing: 2px;
  margin: 1rem 0;
  background: white;
  padding: 1rem;
  border-radius: 12px;
  border: 2px solid <?= $color ?>20;
}

.action-buttons {
  display: flex;
  gap: 1rem;
  justify-content: center;
  flex-wrap: wrap;
  margin: 2rem 0;
}

.btn-modern {
  padding: 1rem 2rem;
  border-radius: 50px;
  font-weight: 600;
  text-decoration: none;
  transition: var(--ci-transition);
  display: inline-flex;
  align-items: center;
  gap: 0.5rem;
  border: 2px solid transparent;
}

.btn-primary-modern {
  background: linear-gradient(135deg, <?= $color ?> 0%, <?= $type === 'ethique' ? '#FF8C42' : '#A5D721' ?> 100%);
  color: white;
}

.btn-primary-modern:hover {
  transform: translateY(-2px);
  box-shadow: 0 8px 20px <?= $color ?>40;
  color: white;
}

.btn-outline-modern {
  border-color: <?= $color ?>;
  color: <?= $color ?>;
  background: white;
}

.btn-outline-modern:hover {
  background: <?= $color ?>;
  color: white;
  transform: translateY(-2px);
}

.security-notice {
  background: var(--ci-light);
  border-radius: var(--ci-radius);
  padding: 1.5rem;
  margin-top: 2rem;
  border-left: 4px solid <?= $color ?>;
}

.security-content {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 1rem;
}

.security-icon {
  color: <?= $color ?>;
  font-size: 1.5rem;
}

.security-text {
  text-align: left;
}

.security-text strong {
  color: var(--ci-dark);
  display: block;
  margin-bottom: 0.25rem;
}

.security-text span {
  color: #6c757d;
  font-size: 0.9rem;
}

@keyframes successPop {
  0% {
    transform: scale(0);
    opacity: 0;
  }
  70% {
    transform: scale(1.1);
    opacity: 1;
  }
  100% {
    transform: scale(1);
  }
}

@keyframes ripple {
  0% {
    transform: scale(1);
    opacity: 1;
  }
  100% {
    transform: scale(1.3);
    opacity: 0;
  }
}

/* Responsive */
@media (max-width: 768px) {
  .success-container {
    padding: 1rem;
  }
  
  .success-card {
    padding: 2rem 1.5rem;
  }
  
  .success-title {
    font-size: 2rem;
  }
  
  .success-message {
    font-size: 1.1rem;
  }
  
  .tracking-number {
    font-size: 2rem;
  }
  
  .action-buttons {
    flex-direction: column;
    align-items: center;
  }
  
  .btn-modern {
    width: 100%;
    max-width: 300px;
    justify-content: center;
  }
  
  .security-content {
    flex-direction: column;
    text-align: center;
    gap: 0.5rem;
  }
  
  .security-text {
    text-align: center;
  }
}

/* Animation de confetti */
.confetti {
  position: fixed;
  width: 10px;
  height: 10px;
  background: <?= $color ?>;
  top: 0;
  opacity: 0;
  pointer-events: none;
}

@keyframes confettiFall {
  0% {
    transform: translateY(0) rotate(0deg);
    opacity: 1;
  }
  100% {
    transform: translateY(100vh) rotate(360deg);
    opacity: 0;
  }
}
</style>

<div class="success-container">
  <div class="success-card">
    
    <!-- Icône animée -->
    <div class="success-icon">
      <i class="fas <?= $icon ?>"></i>
    </div>
    
    <!-- Message principal -->
    <h1 class="success-title">Merci pour votre contribution !</h1>
    <p class="success-message"><?= $message ?></p>
    <p class="success-details"><?= $details ?></p>
    
    <!-- Numéro de suivi -->
    <div class="tracking-card">
      <div class="tracking-label">Votre numéro de suivi</div>
      <div class="tracking-number"><?= htmlspecialchars($numero) ?></div>
      <div class="tracking-label">Conservez-le précieusement</div>
    </div>
    
    <!-- Boutons d'action -->
    <div class="action-buttons">
      <a href="suivi.php" class="btn-modern btn-primary-modern">
        <i class="fas fa-search me-1"></i>Suivre mon dossier
      </a>
      <a href="signalement.php" class="btn-modern btn-outline-modern">
        <i class="fas fa-plus me-1"></i>Nouveau signalement
      </a>
    </div>
    
    <!-- Bouton retour -->
    <div class="mt-4">
      <a href="index.php" class="btn-modern" style="color: #6c757d; border-color: #e9ecef;">
        <i class="fas fa-home me-1"></i>Retour à l'accueil
      </a>
    </div>
    
    <!-- Notice de sécurité -->
    <div class="security-notice">
      <div class="security-content">
        <i class="fas fa-user-shield security-icon"></i>
        <div class="security-text">
          <strong>Votre anonymat est préservé</strong>
          <span>Toutes vos communications sont cryptées et sécurisées</span>
        </div>
      </div>
    </div>
    
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // Animation de confetti simple
  function createConfetti() {
    const colors = ['<?= $color ?>', '#84BD00', '#F36F21', '#2C2C2C'];
    const container = document.body;
    
    for (let i = 0; i < 50; i++) {
      const confetti = document.createElement('div');
      confetti.className = 'confetti';
      confetti.style.left = Math.random() * 100 + 'vw';
      confetti.style.background = colors[Math.floor(Math.random() * colors.length)];
      confetti.style.animation = `confettiFall ${Math.random() * 3 + 2}s linear forwards`;
      confetti.style.animationDelay = Math.random() * 2 + 's';
      container.appendChild(confetti);
      
      // Supprimer après l'animation
      setTimeout(() => {
        confetti.remove();
      }, 5000);
    }
  }
  
  // Lancer les confetti au chargement
  setTimeout(createConfetti, 500);
  
  // Effet de copie du numéro
  const trackingNumber = document.querySelector('.tracking-number');
  if (trackingNumber) {
    trackingNumber.addEventListener('click', function() {
      const text = this.textContent;
      navigator.clipboard.writeText(text).then(() => {
        const originalText = this.textContent;
        this.textContent = 'Copié !';
        this.style.color = '#84BD00';
        
        setTimeout(() => {
          this.textContent = originalText;
          this.style.color = '<?= $color ?>';
        }, 2000);
      });
    });
    
    // Ajouter un indicateur que c'est cliquable
    trackingNumber.style.cursor = 'pointer';
    trackingNumber.title = 'Cliquez pour copier le numéro';
  }
});
</script>

<?php include 'footer.php'; ?>