<?php
// seed_types_situation_from_form.php
// But: extraire les <option> d'un <select> "types de situation" dans signalement.php et peupler la table types_situation

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../src/includes/config.php'; // fournit $pdo

if (!isset($pdo) || !($pdo instanceof PDO)) {
  die("Connexion BD introuvable.");
}

// 1) Localiser & charger signalement.php
$path = __DIR__ . '/signalement.php'; // adapte si nécessaire
if (!file_exists($path)) {
  die("Fichier formulaire introuvable à $path");
}
$html = file_get_contents($path);

// 2) Heuristique : on cherche un select probable
//    - par name: type_situation, situation_id, type_situation_id
//    - ou par id: idem
$selectPatterns = [
  '/<select[^>]*(name|id)\s*=\s*"type_situation"[^>]*>(.*?)<\/select>/is',
  '/<select[^>]*(name|id)\s*=\s*"situation_id"[^>]*>(.*?)<\/select>/is',
  '/<select[^>]*(name|id)\s*=\s*"type_situation_id"[^>]*>(.*?)<\/select>/is',
];

$selectHtml = null;
foreach ($selectPatterns as $pat) {
  if (preg_match($pat, $html, $m)) {
    $selectHtml = $m[2]; // innerHTML du select
    break;
  }
}

if ($selectHtml === null) {
  // fallback: on prend le premier select qui semble contenir “situation” en label ou data
  if (preg_match('/<select[^>]*>(.*?)<\/select>/is', $html, $m)) {
    $selectHtml = $m[1];
  }
}

if ($selectHtml === null) {
  die("Impossible de localiser le <select> des types de situation dans signalement.php");
}

// 3) Extraire les <option> libellés
preg_match_all('/<option[^>]*>(.*?)<\/option>/is', $selectHtml, $opts);
$libelles = [];
foreach ($opts[1] ?? [] as $raw) {
  $lib = trim(html_entity_decode(strip_tags($raw), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'));
  if ($lib !== '' && !in_array(mb_strtolower($lib), array_map('mb_strtolower', $libelles), true)) {
    $libelles[] = $lib;
  }
}

if (!$libelles) {
  die("Aucune <option> trouvée dans le select de type de situation.");
}

// 4) Insérer si absent (dossier_type_id = 1)
$ins = $pdo->prepare("INSERT INTO types_situation (libelle, dossier_type_id) VALUES (?, 1)");
$check = $pdo->prepare("SELECT id FROM types_situation WHERE libelle = ?");

$inserted = 0;
foreach ($libelles as $lib) {
  $check->execute([$lib]);
  $id = (int)$check->fetchColumn();
  if ($id <= 0) {
    $ins->execute([$lib]);
    $inserted++;
  }
}

echo "OK. $inserted type(s) de situation inséré(s).";
