<?php
// Activer les erreurs (uniquement en développement)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Charger la configuration
require_once '../src/includes/config.php';

// Générer un numéro de dossier unique
$numero_dossier = genererNumeroDossier('suggestion');

// Récupérer les types de situation pour les suggestions depuis la base de données
try {
    $sql = "SELECT id, libelle FROM types_situation WHERE dossier_type_id = 2 AND actif = 1 AND id != 1 ORDER BY id";
    $stmt = $pdo->query($sql);
    $types_situation_suggestion = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    // Fallback si la table n'existe pas
    $types_situation_suggestion = [
        ['id' => 8, 'libelle' => 'Amélioration des processus'],
        ['id' => 9, 'libelle' => 'Innovation technique'],
        ['id' => 10, 'libelle' => 'Conditions de travail'],
        ['id' => 11, 'libelle' => 'Relations internes'],
        ['id' => 12, 'libelle' => 'Économie & efficacité'],
        ['id' => 13, 'libelle' => 'Autre']
    ];
    error_log("Erreur chargement types situation suggestion: " . $e->getMessage());
}

// Récupérer les données du formulaire en cas d'erreur
$form_data = $_SESSION['form_data'] ?? [];
$form_errors = $_SESSION['form_errors'] ?? [];

// Nettoyer les données de session après utilisation
unset($_SESSION['form_data']);
unset($_SESSION['form_errors']);
?>

<!-- Inclure le header -->
<?php include 'header.php'; ?>

<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-9 col-xl-8">
      
      <!-- En-tête du formulaire -->
      <div class="text-center mb-5">
        <div class="modern-icon mb-4">
          <div class="icon-wrapper">
            <i class="fas fa-lightbulb"></i>
          </div>
        </div>
        <h1 class="display-6 fw-bold text-dark mb-3">Proposer une suggestion</h1>
        <p class="lead text-muted mb-4">
          Partagez vos idées pour améliorer nos processus, services ou conditions de travail
        </p>
        <div class="dossier-number">
          <span class="dossier-badge">
            <i class="fas fa-hashtag me-2"></i>
            <?= htmlspecialchars($numero_dossier) ?>
          </span>
        </div>
      </div>

      <!-- Affichage des erreurs -->
      <?php if (!empty($form_errors)): ?>
        <div class="alert-modern alert-error">
          <div class="alert-icon">
            <i class="fas fa-exclamation-circle"></i>
          </div>
          <div class="alert-content">
            <h5 class="alert-title">Erreurs à corriger</h5>
            <ul class="alert-list">
              <?php foreach ($form_errors as $error): ?>
                <li><?= htmlspecialchars($error) ?></li>
              <?php endforeach; ?>
            </ul>
          </div>
        </div>
      <?php endif; ?>

      <!-- Formulaire -->
      <div class="modern-card">
        <div class="card-body p-5">
          <form action="save_suggestion.php" method="POST" enctype="multipart/form-data" id="formSuggestion" class="needs-validation" novalidate>

            <!-- Numéro de dossier (caché) -->
            <input type="hidden" name="numero_dossier" value="<?= htmlspecialchars($numero_dossier) ?>">

            <!-- Mode de dépôt -->
            <div class="form-modern mb-4">
              <label class="form-label">
                <span class="label-text">Mode de dépôt</span>
                <span class="required">*</span>
              </label>
              <div class="mode-options">
                <div class="form-check mb-3">
                  <input class="form-check-input" type="radio" name="mode_depot" id="mode_anonyme" value="anonyme" 
                         <?= (isset($form_data['mode_depot']) && $form_data['mode_depot'] === 'anonyme') || !isset($form_data['mode_depot']) ? 'checked' : '' ?>>
                  <label class="form-check-label" for="mode_anonyme">
                    <strong>Anonyme</strong> – Aucune donnée d'identification ne sera collectée
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" name="mode_depot" id="mode_identifie" value="confidentiel"
                         <?= (isset($form_data['mode_depot']) && $form_data['mode_depot'] === 'confidentiel') ? 'checked' : '' ?>>
                  <label class="form-check-label" for="mode_identifie">
                    <strong>Confidentiel</strong> – Vos coordonnées seront connues du service traitant
                  </label>
                </div>
              </div>
            </div>

            <!-- Champs identifiants (visibles seulement si confidentiel) -->
            <div id="champsIdentites" style="display: none;">
              <div class="row g-3 mb-4">
                <div class="col-md-6">
                  <div class="form-modern">
                    <label for="nom_auteur" class="form-label">
                      <span class="label-text">Nom et prénom</span>
                      <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                      <i class="input-icon fas fa-user"></i>
                      <input type="text" name="nom_auteur" id="nom_auteur" class="form-control" 
                             placeholder="Votre nom complet"
                             value="<?= htmlspecialchars($form_data['nom_auteur'] ?? '') ?>">
                    </div>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-modern">
                    <label for="matricule_auteur" class="form-label">
                      <span class="label-text">Matricule</span>
                    </label>
                    <div class="input-wrapper">
                      <i class="input-icon fas fa-id-badge"></i>
                      <input type="text" name="matricule_auteur" id="matricule_auteur" class="form-control" 
                             placeholder="Ex: CI-ENG-1234"
                             value="<?= htmlspecialchars($form_data['matricule_auteur'] ?? '') ?>">
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="form-modern">
                    <label for="service_auteur" class="form-label">
                      <span class="label-text">Service / Département</span>
                    </label>
                    <div class="input-wrapper">
                      <i class="input-icon fas fa-building"></i>
                      <input type="text" name="service_auteur" id="service_auteur" class="form-control" 
                             placeholder="Ex: RH, Production, IT"
                             value="<?= htmlspecialchars($form_data['service_auteur'] ?? '') ?>">
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Thème de la suggestion -->
            <div class="form-modern mb-4">
              <label for="type_situation_id" class="form-label">
                <span class="label-text">Thème de la suggestion</span>
                <span class="required">*</span>
              </label>
              <div class="input-wrapper">
                <i class="input-icon fas fa-tags"></i>
                <select name="type_situation_id" id="type_situation_id" class="form-control" required>
                  <option value="" disabled selected>Choisissez un thème</option>
                  <?php foreach ($types_situation_suggestion as $type): ?>
                    <option value="<?= $type['id'] ?>" 
                      <?= (isset($form_data['type_situation_id']) && $form_data['type_situation_id'] == $type['id']) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($type['libelle']) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="invalid-feedback">Veuillez sélectionner un thème.</div>
            </div>

            <!-- Description -->
            <div class="form-modern mb-4">
              <label for="description" class="form-label">
                <span class="label-text">Description de votre suggestion</span>
                <span class="required">*</span>
              </label>
              <div class="input-wrapper">
                <i class="input-icon fas fa-align-left"></i>
                <textarea name="description" id="description" class="form-control" 
                          rows="6" 
                          placeholder="Décrivez votre idée, ses bénéfices attendus, comment elle pourrait être mise en œuvre..." 
                          required><?= htmlspecialchars($form_data['description'] ?? '') ?></textarea>
              </div>
              <div class="form-text">
                <i class="fas fa-info-circle me-1"></i>
                Soyez le plus précis possible pour faciliter l'étude de votre suggestion
              </div>
              <div class="invalid-feedback">Veuillez fournir une description détaillée.</div>
            </div>

            <!-- Pièce jointe -->
            <div class="form-modern mb-4">
              <label for="fichier" class="form-label">
                <span class="label-text">Pièce jointe</span>
                <span class="optional">(facultatif)</span>
              </label>
              <div class="file-upload-wrapper">
                <input type="file" name="fichier" id="fichier" class="file-input" 
                       accept=".pdf,.jpg,.jpeg,.png,.doc,.docx">
                <label for="fichier" class="file-label">
                  <i class="fas fa-cloud-upload-alt me-2"></i>
                  <span class="file-text">Choisir un fichier</span>
                  <span class="file-hint">PDF, images, documents • Max 10 Mo</span>
                </label>
              </div>
            </div>

            <!-- Formulaire de consentement -->
            <div class="form-modern mb-4">
              <label class="form-label">
                <span class="label-text">Formulaire de Consentement</span>
                <span class="required">*</span>
              </label>
              
              <div class="consent-items">
                <div class="form-check mb-3">
                  <input class="form-check-input" type="checkbox" value="1" id="consent_finalite" name="consent_finalite" required
                         <?= (isset($form_data['consent_finalite'])) ? 'checked' : '' ?>>
                  <label class="form-check-label" for="consent_finalite">
                    Je comprends que mes données seront utilisées uniquement pour traiter ma suggestion et renforcer la gouvernance interne.
                  </label>
                </div>

                <div class="form-check mb-3">
                  <input class="form-check-input" type="checkbox" value="1" id="consent_donnees" name="consent_donnees" required
                         <?= (isset($form_data['consent_donnees'])) ? 'checked' : '' ?>>
                  <label class="form-check-label" for="consent_donnees">
                    Si je me suis identifié(e), je sais que mes données (nom, matricule, service) seront accessibles au Service du Courrier et aux destinataires légitimes.
                  </label>
                </div>

                <div class="form-check mb-3">
                  <input class="form-check-input" type="checkbox" value="1" id="consent_duree" name="consent_duree" required
                         <?= (isset($form_data['consent_duree'])) ? 'checked' : '' ?>>
                  <label class="form-check-label" for="consent_duree">
                    J'ai pris connaissance des durées de conservation des données (jusqu'à 2 ans).
                  </label>
                </div>

                <div class="form-check mb-3">
                  <input class="form-check-input" type="checkbox" value="1" id="consent_retour" name="consent_retour" required
                         <?= (isset($form_data['consent_retour'])) ? 'checked' : '' ?>>
                  <label class="form-check-label" for="consent_retour">
                    Je donne mon consentement pour être recontacté(e) si nécessaire.
                  </label>
                </div>
              </div>

              <div class="consent-notice">
                <i class="fas fa-info-circle me-2"></i>
                En cochant ces cases, je confirme avoir lu la <a href="#" class="policy-link">Politique de Confidentialité</a> et je donne mon consentement libre, spécifique et informé.
              </div>
            </div>

            <!-- Bouton de soumission -->
            <div class="form-modern mt-5">
              <button type="submit" class="btn-submit">
                <span class="btn-content">
                  <i class="fas fa-paper-plane me-2"></i>Soumettre la suggestion
                </span>
                <div class="btn-loading">
                  <i class="fas fa-spinner fa-spin"></i>
                </div>
              </button>
            </div>

          </form>
        </div>
      </div>

      <!-- Informations de confidentialité -->
      <div class="modern-info mt-4">
        <div class="info-content">
          <i class="fas fa-user-shield info-icon"></i>
          <div class="info-text">
            <strong>Confidentialité garantie</strong>
            <span>Votre suggestion est traitée avec la plus stricte confidentialité</span>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<style>
:root {
  --ci-orange: #F36F21;
  --ci-green: #2E7D32;  /* Vert plus sombre et élégant */
  --ci-green-light: #4CAF50; /* Version plus claire pour les dégradés */
  --ci-dark: #2C2C2C;
  --ci-light: #F8F9FA;
  --ci-border: #E1E5E9;
  --ci-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
  --ci-radius: 12px;
  --ci-transition: all 0.3s ease;
}

.modern-icon {
  display: flex;
  justify-content: center;
}

.icon-wrapper {
  width: 80px;
  height: 80px;
  background: linear-gradient(135deg, var(--ci-green) 0%, var(--ci-green-light) 100%);
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  box-shadow: var(--ci-shadow);
}

.icon-wrapper i {
  font-size: 2rem;
  color: white;
}

.display-6 {
  font-size: 2.5rem;
  font-weight: 800;
}

.lead {
  font-size: 1.25rem;
  font-weight: 400;
}

.dossier-badge {
  display: inline-block;
  background: var(--ci-light);
  border: 2px dashed var(--ci-green);
  border-radius: 50px;
  padding: 12px 24px;
  font-weight: 600;
  color: var(--ci-dark);
  font-size: 1.1rem;
}

.modern-card {
  background: white;
  border-radius: var(--ci-radius);
  box-shadow: var(--ci-shadow);
  border: none;
  overflow: hidden;
}

.form-modern {
  position: relative;
}

.form-label {
  display: flex;
  align-items: center;
  margin-bottom: 12px;
  font-weight: 600;
  color: var(--ci-dark);
  font-size: 1rem;
}

.label-text {
  margin-right: 4px;
}

.required {
  color: #dc3545;
}

.optional {
  color: #6c757d;
  font-weight: 400;
  font-size: 0.9rem;
}

.input-wrapper {
  position: relative;
  display: flex;
  align-items: center;
}

.input-icon {
  position: absolute;
  left: 16px;
  color: var(--ci-green);
  z-index: 2;
  font-size: 1.1rem;
}

.form-control {
  width: 100%;
  padding: 16px 16px 16px 48px;
  border: 2px solid var(--ci-border);
  border-radius: var(--ci-radius);
  font-size: 1rem;
  transition: var(--ci-transition);
  background: white;
}

.form-control:focus {
  border-color: var(--ci-green);
  box-shadow: 0 0 0 4px rgba(46, 125, 50, 0.1);
  outline: none;
}

select.form-control {
  appearance: none;
  background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%232E7D32' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
  background-repeat: no-repeat;
  background-position: right 16px center;
  padding-right: 48px;
}

textarea.form-control {
  resize: vertical;
  min-height: 120px;
}

.form-text {
  margin-top: 8px;
  color: #6c757d;
  font-size: 0.875rem;
}

.file-upload-wrapper {
  position: relative;
}

.file-input {
  position: absolute;
  opacity: 0;
  width: 0;
  height: 0;
}

.file-label {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 32px;
  border: 2px dashed var(--ci-border);
  border-radius: var(--ci-radius);
  background: var(--ci-light);
  cursor: pointer;
  transition: var(--ci-transition);
  text-align: center;
}

.file-label:hover {
  border-color: var(--ci-green);
  background: rgba(46, 125, 50, 0.05);
}

.file-text {
  font-weight: 600;
  color: var(--ci-dark);
  margin-bottom: 8px;
}

.file-hint {
  font-size: 0.875rem;
  color: #6c757d;
}

.btn-submit {
  width: 100%;
  background: linear-gradient(135deg, var(--ci-green) 0%, var(--ci-green-light) 100%);
  border: none;
  border-radius: var(--ci-radius);
  padding: 20px;
  color: white;
  font-weight: 700;
  font-size: 1.1rem;
  transition: var(--ci-transition);
  cursor: pointer;
  position: relative;
  overflow: hidden;
}

.btn-submit:hover {
  transform: translateY(-2px);
  box-shadow: 0 12px 25px rgba(46, 125, 50, 0.3);
}

.btn-loading {
  display: none;
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}

.btn-submit.loading .btn-content {
  opacity: 0;
}

.btn-submit.loading .btn-loading {
  display: block;
}

.alert-modern {
  display: flex;
  align-items: flex-start;
  padding: 20px;
  border-radius: var(--ci-radius);
  margin-bottom: 24px;
  background: #fff5f5;
  border-left: 4px solid #e53e3e;
}

.alert-error {
  background: #fff5f5;
  border-left-color: #e53e3e;
}

.alert-icon {
  margin-right: 12px;
  color: #e53e3e;
  font-size: 1.2rem;
}

.alert-title {
  margin: 0 0 8px 0;
  color: #c53030;
  font-size: 1rem;
}

.alert-list {
  margin: 0;
  padding-left: 20px;
  color: #742a2a;
}

.modern-info {
  background: linear-gradient(135deg, #f1f8e9 0%, #e8f5e8 100%);
  border-radius: var(--ci-radius);
  padding: 20px;
  border: 1px solid #c8e6c9;
}

.info-content {
  display: flex;
  align-items: center;
  justify-content: center;
}

.info-icon {
  font-size: 1.5rem;
  color: var(--ci-green);
  margin-right: 12px;
}

.info-text {
  display: flex;
  flex-direction: column;
}

.info-text strong {
  color: var(--ci-dark);
  font-size: 0.9rem;
}

.info-text span {
  color: #6c757d;
  font-size: 0.85rem;
}

.invalid-feedback {
  color: #dc3545;
  font-size: 0.875rem;
  margin-top: 6px;
}

.consent-notice {
  background: white;
  border-radius: 8px;
  padding: 1rem 1.5rem;
  margin-top: 1.5rem;
  border-left: 4px solid var(--ci-green);
  font-size: 0.9rem;
  color: #6c757d;
}

.policy-link {
  color: var(--ci-green);
  text-decoration: none;
  font-weight: 600;
}

.policy-link:hover {
  text-decoration: underline;
  color: var(--ci-green);
}

.was-validated .form-control:invalid {
  border-color: #dc3545;
}

.form-check-input:checked {
  background-color: var(--ci-green);
  border-color: var(--ci-green);
}

.form-check-input:focus {
  border-color: var(--ci-green);
  box-shadow: 0 0 0 0.2rem rgba(46, 125, 50, 0.25);
}

@media (max-width: 768px) {
  .container {
    padding: 1rem;
  }
  
  .card-body {
    padding: 2rem !important;
  }
  
  .display-6 {
    font-size: 2rem;
  }
  
  .lead {
    font-size: 1.1rem;
  }
  
  .icon-wrapper {
    width: 70px;
    height: 70px;
  }
  
  .icon-wrapper i {
    font-size: 1.7rem;
  }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const modeAnonyme = document.getElementById('mode_anonyme');
  const modeIdentifie = document.getElementById('mode_identifie');
  const champsIdentites = document.getElementById('champsIdentites');
  const nomAuteur = document.getElementById('nom_auteur');
  const form = document.getElementById('formSuggestion');
  const fileInput = document.getElementById('fichier');
  const fileLabel = document.querySelector('.file-label');
  const fileText = document.querySelector('.file-text');
  const submitBtn = document.querySelector('.btn-submit');

  function toggleChamps() {
    if (modeIdentifie.checked) {
      champsIdentites.style.display = 'block';
      // Rendre le champ nom obligatoire en mode identifié
      if (nomAuteur) {
        nomAuteur.required = true;
      }
    } else {
      champsIdentites.style.display = 'none';
      // Rendre le champ nom optionnel en mode anonyme
      if (nomAuteur) {
        nomAuteur.required = false;
      }
    }
  }

  // Écouter les changements
  modeAnonyme.addEventListener('change', toggleChamps);
  modeIdentifie.addEventListener('change', toggleChamps);

  // Gestion de l'upload de fichier
  if (fileInput) {
    fileInput.addEventListener('change', function() {
      if (this.files && this.files[0]) {
        fileText.textContent = this.files[0].name;
      } else {
        fileText.textContent = 'Choisir un fichier';
      }
    });
  }

  // Validation du formulaire
  form.addEventListener('submit', function(event) {
    if (!form.checkValidity()) {
      event.preventDefault();
      event.stopPropagation();
    } else {
      // Ajouter la classe de chargement au bouton
      submitBtn.classList.add('loading');
      submitBtn.disabled = true;
    }
    
    form.classList.add('was-validated');
  }, false);

  // Initialiser en fonction des données existantes
  toggleChamps();
});
</script>

<!-- Inclure le footer -->
<?php include 'footer.php'; ?>