<?php
// Activer les erreurs (développement uniquement)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Charger la configuration
require_once '../src/includes/config.php';

// Initialiser les variables
$numero_dossier = '';
$message = '';
$dossier = null;
$error = false;
$theme = 'default'; // default, orange (signalement), green (suggestion)

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $numero_dossier = trim($_POST['numero_dossier'] ?? '');

    if (empty($numero_dossier)) {
        $message = "Veuillez entrer un numéro de dossier.";
        $error = true;
    } else {
        try {
            // Requête sécurisée
            $stmt = $pdo->prepare("
                SELECT 
                    d.numero_dossier,
                    d.type_id,
                    tt.libelle AS type_libelle,
                    s.nom_service AS service_cible,
                    st.libelle AS statut_libelle,
                    d.date_creation,
                    d.date_maj,
                    d.commentaire_interne
                FROM dossiers d
                JOIN types_dossier tt ON d.type_id = tt.id
                JOIN services s ON d.service_cible_id = s.id
                JOIN statuts st ON d.statut_id = st.id
                WHERE d.numero_dossier = ?
            ");
            $stmt->execute([$numero_dossier]);
            $dossier = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$dossier) {
                $message = "Aucun dossier trouvé avec ce numéro.";
                $error = true;
            } else {
                // Déterminer le thème en fonction du type de dossier
                $theme = ($dossier['type_id'] == 1) ? 'orange' : 'green';
            }
        } catch (Exception $e) {
            $message = "Erreur lors de la recherche : " . $e->getMessage();
            $error = true;
        }
    }
}
?>

<!-- Inclure le header -->
<?php include 'header.php'; ?>

<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-9 col-xl-8">
      
      <!-- En-tête -->
      <div class="text-center mb-5">
        <div class="modern-icon mb-4">
          <div class="icon-wrapper search-icon">
            <i class="fas fa-search"></i>
          </div>
        </div>
        <h1 class="display-6 fw-bold text-dark mb-3">Suivre mon dossier</h1>
        <p class="lead text-muted mb-4">
          Saisissez votre numéro de suivi pour consulter l'état de votre signalement ou suggestion
        </p>
      </div>

      <!-- Formulaire de recherche - NEUTRE (noir et blanc) -->
      <div class="modern-card search-card">
        <div class="card-body p-5">
          <form method="POST" id="formSuivi">
            <div class="form-modern">
              <label for="numero_dossier" class="form-label">
                <span class="label-text">Numéro de dossier</span>
                <span class="required">*</span>
              </label>
              <div class="input-wrapper">
                <i class="input-icon fas fa-hashtag"></i>
                <input
                  type="text"
                  name="numero_dossier"
                  id="numero_dossier"
                  class="form-control"
                  placeholder="Ex: CI-ETH-7X9K2P ou CI-SUG-8Y3L4M"
                  value="<?= htmlspecialchars($numero_dossier) ?>"
                  required
                  maxlength="20"
                  style="font-size: 1.1rem;"
                >
              </div>
              <div class="form-text">
                <i class="fas fa-info-circle me-1"></i>
                Le numéro de dossier vous a été communiqué lors de la soumission
              </div>
            </div>

            <div class="form-modern mt-4">
              <button type="submit" class="btn-submit search-btn">
                <span class="btn-content">
                  <i class="fas fa-search me-2"></i>Rechercher le dossier
                </span>
                <div class="btn-loading">
                  <i class="fas fa-spinner fa-spin"></i>
                </div>
              </button>
            </div>
          </form>
        </div>
      </div>

      <!-- Message d'erreur ou succès -->
      <?php if ($message): ?>
        <div class="alert-modern <?= $error ? 'alert-error' : 'alert-success' ?>">
          <div class="alert-icon">
            <i class="fas <?= $error ? 'fa-exclamation-circle' : 'fa-check-circle' ?>"></i>
          </div>
          <div class="alert-content">
            <h5 class="alert-title"><?= $error ? 'Erreur' : 'Succès' ?></h5>
            <p class="mb-0"><?= htmlspecialchars($message) ?></p>
          </div>
        </div>
      <?php endif; ?>

      <!-- Résultat du suivi -->
      <?php if ($dossier): ?>
        <div class="modern-card result-card theme-<?= $theme ?>">
          <div class="card-header theme-<?= $theme ?>">
            <div class="d-flex justify-content-between align-items-center">
              <div>
                <h4 class="mb-1 text-dark">Dossier <?= htmlspecialchars($dossier['numero_dossier']) ?></h4>
                <span class="type-badge theme-<?= $theme ?>"><?= htmlspecialchars($dossier['type_libelle']) ?></span>
              </div>
              <div class="status-indicator">
                <div class="status-badge status-<?= 
                  $dossier['statut_libelle'] === 'Reçu' ? 'received' :
                  ($dossier['statut_libelle'] === 'En cours d\'analyse' ? 'analysis' :
                  ($dossier['statut_libelle'] === 'Clôturé – action entreprise' ? 'closed' : 'default'))
                ?> theme-<?= $theme ?>">
                  <?= htmlspecialchars($dossier['statut_libelle']) ?>
                </div>
              </div>
            </div>
          </div>
          
          <div class="card-body p-5">
            <div class="row g-4">
              <!-- Informations principales -->
              <div class="col-md-6">
                <div class="info-item theme-<?= $theme ?>">
                  <div class="info-icon theme-<?= $theme ?>">
                    <i class="fas fa-building"></i>
                  </div>
                  <div class="info-content">
                    <label>Service traitant</label>
                    <strong><?= htmlspecialchars($dossier['service_cible']) ?></strong>
                  </div>
                </div>
              </div>
              
              <div class="col-md-6">
                <div class="info-item theme-<?= $theme ?>">
                  <div class="info-icon theme-<?= $theme ?>">
                    <i class="fas fa-calendar-plus"></i>
                  </div>
                  <div class="info-content">
                    <label>Date de dépôt</label>
                    <strong><?= (new DateTime($dossier['date_creation']))->format('d/m/Y à H:i') ?></strong>
                  </div>
                </div>
              </div>
              
              <div class="col-md-6">
                <div class="info-item theme-<?= $theme ?>">
                  <div class="info-icon theme-<?= $theme ?>">
                    <i class="fas fa-sync-alt"></i>
                  </div>
                  <div class="info-content">
                    <label>Dernière mise à jour</label>
                    <strong><?= (new DateTime($dossier['date_maj']))->format('d/m/Y à H:i') ?></strong>
                  </div>
                </div>
              </div>

              <!-- Timeline avec indication du niveau actuel -->
              <div class="col-12">
                <div class="timeline-section theme-<?= $theme ?>">
                  <h5 class="timeline-title theme-<?= $theme ?>">
                    <i class="fas fa-history me-2"></i>Progression du dossier
                  </h5>
                  
                  <?php
                  // Déterminer l'étape actuelle
                  $current_step = 1;
                  if ($dossier['statut_libelle'] === 'En cours d\'analyse') {
                      $current_step = 2;
                  } elseif ($dossier['statut_libelle'] === 'Clôturé – action entreprise') {
                      $current_step = 3;
                  }
                  ?>
                  
                  <div class="current-step-indicator mb-4">
                    <div class="step-indicator theme-<?= $theme ?>">
                      <div class="step-dot step-1 <?= $current_step >= 1 ? 'active' : '' ?> <?= $current_step == 1 ? 'current' : '' ?>"></div>
                      <div class="step-dot step-2 <?= $current_step >= 2 ? 'active' : '' ?> <?= $current_step == 2 ? 'current' : '' ?>"></div>
                      <div class="step-dot step-3 <?= $current_step >= 3 ? 'active' : '' ?> <?= $current_step == 3 ? 'current' : '' ?>"></div>
                    </div>
                    <div class="step-label">
                      <span class="step-text <?= $current_step == 1 ? 'current' : '' ?>">Déposé</span>
                      <span class="step-text <?= $current_step == 2 ? 'current' : '' ?>">En analyse</span>
                      <span class="step-text <?= $current_step == 3 ? 'current' : '' ?>">Terminé</span>
                    </div>
                  </div>

                  <div class="timeline">
                    <div class="timeline-item <?= $current_step >= 1 ? 'active' : '' ?> <?= $current_step == 1 ? 'current-step' : '' ?> theme-<?= $theme ?>">
                      <div class="timeline-marker <?= $current_step >= 1 ? 'active' : '' ?> <?= $current_step == 1 ? 'current' : '' ?> theme-<?= $theme ?>">
                        <?php if ($current_step == 1): ?>
                          <div class="current-pulse"></div>
                        <?php endif; ?>
                      </div>
                      <div class="timeline-content">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <strong>Dossier déposé</strong>
                            <span class="d-block text-muted">Votre dossier a été enregistré avec succès</span>
                          </div>
                          <span class="timeline-date"><?= (new DateTime($dossier['date_creation']))->format('d/m/Y') ?></span>
                        </div>
                        <?php if ($current_step == 1): ?>
                          <div class="current-step-badge">
                            <i class="fas fa-user-clock me-1"></i>Étape en cours
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>
                    
                    <div class="timeline-item <?= $current_step >= 2 ? 'active' : '' ?> <?= $current_step == 2 ? 'current-step' : '' ?> theme-<?= $theme ?>">
                      <div class="timeline-marker <?= $current_step >= 2 ? 'active' : '' ?> <?= $current_step == 2 ? 'current' : '' ?> theme-<?= $theme ?>">
                        <?php if ($current_step == 2): ?>
                          <div class="current-pulse"></div>
                        <?php endif; ?>
                      </div>
                      <div class="timeline-content">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <strong>En cours d'analyse</strong>
                            <span class="d-block text-muted">Notre équipe étudie votre dossier</span>
                          </div>
                          <span class="timeline-date">
                            <?= $dossier['statut_libelle'] === 'En cours d\'analyse' || $dossier['statut_libelle'] === 'Clôturé – action entreprise' ? 
                            (new DateTime($dossier['date_maj']))->format('d/m/Y') : 'En attente' ?>
                          </span>
                        </div>
                        <?php if ($current_step == 2): ?>
                          <div class="current-step-badge">
                            <i class="fas fa-spinner me-1"></i>Étape en cours
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>
                    
                    <div class="timeline-item <?= $current_step >= 3 ? 'active' : '' ?> <?= $current_step == 3 ? 'current-step' : '' ?> theme-<?= $theme ?>">
                      <div class="timeline-marker <?= $current_step >= 3 ? 'active' : '' ?> <?= $current_step == 3 ? 'current' : '' ?> theme-<?= $theme ?>">
                        <?php if ($current_step == 3): ?>
                          <div class="current-pulse"></div>
                        <?php endif; ?>
                      </div>
                      <div class="timeline-content">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <strong>Traitement terminé</strong>
                            <span class="d-block text-muted">Votre dossier a été traité</span>
                          </div>
                          <span class="timeline-date">
                            <?= $dossier['statut_libelle'] === 'Clôturé – action entreprise' ? 
                            (new DateTime($dossier['date_maj']))->format('d/m/Y') : 'En attente' ?>
                          </span>
                        </div>
                        <?php if ($current_step == 3): ?>
                          <div class="current-step-badge completed">
                            <i class="fas fa-check me-1"></i>Terminé
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Message du service -->
              <?php if (!empty($dossier['commentaire_interne'])): ?>
                <div class="col-12">
                  <div class="message-section theme-<?= $theme ?>">
                    <div class="message-header theme-<?= $theme ?>">
                      <i class="fas fa-comment-alt me-2"></i>
                      <span>Message du service</span>
                    </div>
                    <div class="message-content">
                      <?= nl2br(htmlspecialchars($dossier['commentaire_interne'])) ?>
                    </div>
                  </div>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Actions supplémentaires -->
        <div class="action-buttons mt-4">
          <a href="index.php" class="btn-action btn-secondary">
            <i class="fas fa-home me-2"></i>Retour à l'accueil
          </a>
          <?php if ($theme == 'orange'): ?>
            <a href="signalement.php" class="btn-action btn-outline theme-orange">
              <i class="fas fa-plus me-2"></i>Nouveau signalement
            </a>
          <?php else: ?>
            <a href="suggestion.php" class="btn-action btn-outline theme-green">
              <i class="fas fa-lightbulb me-2"></i>Nouvelle suggestion
            </a>
          <?php endif; ?>
        </div>

      <?php endif; ?>

    </div>
  </div>
</div>

<style>
:root {
  --ci-orange: #F36F21;
  --ci-orange-light: #FF8C42;
  --ci-green: #2E7D32;
  --ci-green-light: #4CAF50;
  --ci-dark: #2C2C2C;
  --ci-light: #F8F9FA;
  --ci-border: #E1E5E9;
  --ci-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
  --ci-radius: 16px;
  --ci-transition: all 0.3s ease;
}

/* Thèmes de couleur pour les résultats */
.theme-orange {
  --ci-primary: var(--ci-orange);
  --ci-primary-light: var(--ci-orange-light);
  --ci-gradient: linear-gradient(135deg, var(--ci-orange) 0%, var(--ci-orange-light) 100%);
  --ci-light-bg: #FFF3E0;
  --ci-border-light: #FFB74D;
  --ci-shadow-color: rgba(243, 111, 33, 0.3);
}

.theme-green {
  --ci-primary: var(--ci-green);
  --ci-primary-light: var(--ci-green-light);
  --ci-gradient: linear-gradient(135deg, var(--ci-green) 0%, var(--ci-green-light) 100%);
  --ci-light-bg: #F1F8E9;
  --ci-border-light: #C8E6C9;
  --ci-shadow-color: rgba(46, 125, 50, 0.3);
}

/* Styles pour le formulaire de recherche NEUTRE (noir et blanc) */
.search-icon {
  background: linear-gradient(135deg, #666 0%, #999 100%);
}

.search-card {
  background: white;
  border: 2px solid var(--ci-border);
}

.search-btn {
  background: linear-gradient(135deg, #2C2C2C 0%, #555 100%);
  color: white;
}

.search-btn:hover {
  box-shadow: 0 12px 25px rgba(44, 44, 44, 0.3);
  transform: translateY(-2px);
  background: linear-gradient(135deg, #444 0%, #666 100%);
}

/* Styles généraux réutilisables */
.modern-icon {
  display: flex;
  justify-content: center;
}

.icon-wrapper {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  box-shadow: var(--ci-shadow);
}

.icon-wrapper i {
  font-size: 2rem;
  color: white;
}

.display-6 {
  font-size: 2.5rem;
  font-weight: 800;
}

.lead {
  font-size: 1.25rem;
  font-weight: 400;
}

/* Carte de recherche */
.search-card {
  border: 2px solid transparent;
  transition: var(--ci-transition);
}

/* Formulaire */
.form-modern {
  position: relative;
}

.form-label {
  display: flex;
  align-items: center;
  margin-bottom: 12px;
  font-weight: 600;
  color: var(--ci-dark);
  font-size: 1rem;
}

.label-text {
  margin-right: 4px;
}

.required {
  color: #dc3545;
}

.input-wrapper {
  position: relative;
  display: flex;
  align-items: center;
}

.input-icon {
  position: absolute;
  left: 16px;
  color: #666;
  z-index: 2;
  font-size: 1.1rem;
}

.form-control {
  width: 100%;
  padding: 16px 16px 16px 48px;
  border: 2px solid var(--ci-border);
  border-radius: var(--ci-radius);
  font-size: 1rem;
  transition: var(--ci-transition);
  background: white;
}

.form-control:focus {
  border-color: #666;
  box-shadow: 0 0 0 4px rgba(102, 102, 102, 0.1);
  outline: none;
}

.form-text {
  margin-top: 8px;
  color: #6c757d;
  font-size: 0.875rem;
}

/* Boutons */
.btn-submit {
  width: 100%;
  border: none;
  border-radius: var(--ci-radius);
  padding: 20px;
  color: white;
  font-weight: 700;
  font-size: 1.1rem;
  transition: var(--ci-transition);
  cursor: pointer;
  position: relative;
  overflow: hidden;
}

.btn-loading {
  display: none;
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}

.btn-submit.loading .btn-content {
  opacity: 0;
}

.btn-submit.loading .btn-loading {
  display: block;
}

/* Carte de résultats */
.modern-card {
  background: white;
  border-radius: var(--ci-radius);
  box-shadow: var(--ci-shadow);
  border: none;
  overflow: hidden;
}

.result-card {
  animation: fadeInUp 0.6s ease-out;
}

.card-header {
  padding: 2rem 2.5rem;
  border-bottom: 1px solid var(--ci-border);
}

.card-header.theme-orange {
  background: linear-gradient(135deg, #FFF3E0 0%, #FFECB3 100%);
}

.card-header.theme-green {
  background: linear-gradient(135deg, #F1F8E9 0%, #DCEDC8 100%);
}

.type-badge {
  padding: 0.5rem 1rem;
  border-radius: 50px;
  font-size: 0.875rem;
  font-weight: 600;
}

.type-badge.theme-orange {
  background: var(--ci-light-bg);
  color: var(--ci-primary);
  border: 1px solid var(--ci-border-light);
}

.type-badge.theme-green {
  background: var(--ci-light-bg);
  color: var(--ci-primary);
  border: 1px solid var(--ci-border-light);
}

.status-badge {
  padding: 0.75rem 1.5rem;
  border-radius: 50px;
  font-weight: 700;
  font-size: 0.9rem;
}

.status-badge.theme-orange {
  background: var(--ci-light-bg);
  color: var(--ci-primary);
  border: 1px solid var(--ci-border-light);
}

.status-badge.theme-green {
  background: var(--ci-light-bg);
  color: var(--ci-primary);
  border: 1px solid var(--ci-border-light);
}

/* Éléments d'information */
.info-item {
  display: flex;
  align-items: center;
  gap: 1rem;
  padding: 1.5rem;
  border-radius: var(--ci-radius);
  border: 1px solid var(--ci-border);
}

.info-item.theme-orange {
  background: var(--ci-light-bg);
}

.info-item.theme-green {
  background: var(--ci-light-bg);
}

.info-icon {
  width: 50px;
  height: 50px;
  border-radius: 12px;
  display: flex;
  align-items: center;
  justify-content: center;
  color: white;
  font-size: 1.2rem;
  flex-shrink: 0;
}

.info-icon.theme-orange {
  background: var(--ci-primary);
}

.info-icon.theme-green {
  background: var(--ci-primary);
}

.info-content label {
  display: block;
  color: #6c757d;
  font-size: 0.875rem;
  margin-bottom: 0.25rem;
}

.info-content strong {
  display: block;
  color: var(--ci-dark);
  font-size: 1rem;
  font-weight: 600;
}

/* Timeline améliorée avec indicateur de niveau */
.current-step-indicator {
  text-align: center;
  margin-bottom: 2rem;
  padding: 1.5rem;
  background: white;
  border-radius: var(--ci-radius);
  border: 1px solid var(--ci-border);
}

.step-indicator {
  display: flex;
  justify-content: center;
  align-items: center;
  margin-bottom: 1rem;
  position: relative;
}

.step-indicator::before {
  content: '';
  position: absolute;
  top: 50%;
  left: 25%;
  right: 25%;
  height: 3px;
  background: var(--ci-border);
  transform: translateY(-50%);
  z-index: 1;
}

.step-dot {
  width: 24px;
  height: 24px;
  border-radius: 50%;
  background: var(--ci-border);
  border: 3px solid white;
  position: relative;
  z-index: 2;
  transition: var(--ci-transition);
}

.step-dot.active {
  background: #BDBDBD;
}

.step-dot.active.current {
  background: var(--ci-primary);
  box-shadow: 0 0 0 4px rgba(102, 102, 102, 0.2);
  animation: pulse 2s infinite;
}

.step-dot.step-1 { margin-right: auto; }
.step-dot.step-2 { margin: 0 auto; }
.step-dot.step-3 { margin-left: auto; }

.step-label {
  display: flex;
  justify-content: space-between;
  padding: 0 10%;
}

.step-text {
  font-size: 0.875rem;
  color: #9E9E9E;
  font-weight: 500;
  transition: var(--ci-transition);
}

.step-text.current {
  color: var(--ci-primary);
  font-weight: 700;
}

/* Timeline */
.timeline-section {
  border-radius: var(--ci-radius);
  padding: 2rem;
  border: 1px solid var(--ci-border);
}

.timeline-section.theme-orange {
  background: var(--ci-light-bg);
}

.timeline-section.theme-green {
  background: var(--ci-light-bg);
}

.timeline-title {
  margin-bottom: 1.5rem;
  font-weight: 600;
}

.timeline-title.theme-orange {
  color: var(--ci-primary);
}

.timeline-title.theme-green {
  color: var(--ci-primary);
}

.timeline {
  position: relative;
  padding-left: 2rem;
}

.timeline::before {
  content: '';
  position: absolute;
  left: 15px;
  top: 0;
  bottom: 0;
  width: 2px;
  background: var(--ci-border);
  z-index: 1;
}

.timeline-item {
  position: relative;
  margin-bottom: 2rem;
  padding: 1.5rem;
  background: white;
  border-radius: var(--ci-radius);
  border: 1px solid var(--ci-border);
  transition: var(--ci-transition);
}

.timeline-item:last-child {
  margin-bottom: 0;
}

.timeline-item.current-step {
  border-color: var(--ci-primary);
  box-shadow: 0 4px 12px rgba(102, 102, 102, 0.15);
}

.timeline-marker {
  position: absolute;
  left: -2rem;
  top: 50%;
  transform: translateY(-50%);
  width: 32px;
  height: 32px;
  border-radius: 50%;
  background: var(--ci-border);
  border: 4px solid white;
  z-index: 2;
  transition: var(--ci-transition);
  display: flex;
  align-items: center;
  justify-content: center;
}

.timeline-marker.active {
  background: #BDBDBD;
}

.timeline-marker.active.current {
  background: var(--ci-primary);
  box-shadow: 0 0 0 4px rgba(102, 102, 102, 0.2);
}

.current-pulse {
  width: 8px;
  height: 8px;
  background: white;
  border-radius: 50%;
  animation: pulse 2s infinite;
}

.timeline-content {
  padding-left: 0;
}

.timeline-content strong {
  display: block;
  color: var(--ci-dark);
  font-weight: 600;
  margin-bottom: 0.25rem;
}

.timeline-date {
  color: var(--ci-primary);
  font-weight: 600;
  font-size: 0.9rem;
}

.current-step-badge {
  display: inline-block;
  background: var(--ci-primary);
  color: white;
  padding: 0.5rem 1rem;
  border-radius: 50px;
  font-size: 0.875rem;
  font-weight: 600;
  margin-top: 0.5rem;
}

.current-step-badge.completed {
  background: #4CAF50;
}

/* Message section */
.message-section {
  background: white;
  border-radius: var(--ci-radius);
  border: 1px solid var(--ci-border);
  overflow: hidden;
}

.message-header {
  padding: 1.5rem 2rem;
  border-bottom: 1px solid var(--ci-border);
  font-weight: 600;
  color: var(--ci-dark);
}

.message-header.theme-orange {
  background: linear-gradient(135deg, #FFF3E0 0%, #FFECB3 100%);
}

.message-header.theme-green {
  background: linear-gradient(135deg, #F1F8E9 0%, #DCEDC8 100%);
}

.message-content {
  padding: 2rem;
  line-height: 1.6;
  color: var(--ci-dark);
}

/* Alert modern */
.alert-modern {
  display: flex;
  align-items: flex-start;
  padding: 1.5rem;
  border-radius: var(--ci-radius);
  margin-bottom: 2rem;
  border-left: 4px solid;
}

.alert-error {
  background: #fff5f5;
  border-left-color: #e53e3e;
}

.alert-success {
  background: #f0f9f0;
  border-left-color: #666;
}

.alert-icon {
  margin-right: 1rem;
  font-size: 1.5rem;
  flex-shrink: 0;
}

.alert-error .alert-icon {
  color: #e53e3e;
}

.alert-success .alert-icon {
  color: #666;
}

.alert-content {
  flex: 1;
}

.alert-title {
  margin: 0 0 0.5rem 0;
  font-size: 1.1rem;
  font-weight: 600;
}

.alert-error .alert-title {
  color: #c53030;
}

.alert-success .alert-title {
  color: #666;
}

/* Action buttons */
.action-buttons {
  display: flex;
  gap: 1rem;
  justify-content: center;
  flex-wrap: wrap;
}

.btn-action {
  padding: 1rem 2rem;
  border-radius: 50px;
  font-weight: 600;
  text-decoration: none;
  transition: var(--ci-transition);
  display: inline-flex;
  align-items: center;
  border: 2px solid transparent;
}

.btn-secondary {
  background: var(--ci-dark);
  color: white;
}

.btn-secondary:hover {
  background: #1a1a1a;
  color: white;
  transform: translateY(-2px);
}

.btn-outline {
  background: white;
  transition: var(--ci-transition);
}

.btn-outline.theme-orange {
  border-color: var(--ci-orange);
  color: var(--ci-orange);
}

.btn-outline.theme-orange:hover {
  background: var(--ci-orange);
  color: white;
  transform: translateY(-2px);
}

.btn-outline.theme-green {
  border-color: var(--ci-green);
  color: var(--ci-green);
}

.btn-outline.theme-green:hover {
  background: var(--ci-green);
  color: white;
  transform: translateY(-2px);
}

/* Animations */
@keyframes fadeInUp {
  from {
    opacity: 0;
    transform: translateY(30px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

@keyframes pulse {
  0% {
    box-shadow: 0 0 0 0 rgba(102, 102, 102, 0.4);
  }
  70% {
    box-shadow: 0 0 0 10px rgba(102, 102, 102, 0);
  }
  100% {
    box-shadow: 0 0 0 0 rgba(102, 102, 102, 0);
  }
}

/* Responsive */
@media (max-width: 768px) {
  .container {
    padding: 1rem;
  }
  
  .card-body {
    padding: 2rem !important;
  }
  
  .card-header {
    padding: 1.5rem;
  }
  
  .info-item {
    flex-direction: column;
    text-align: center;
    gap: 1rem;
  }
  
  .step-label {
    padding: 0 5%;
  }
  
  .step-text {
    font-size: 0.8rem;
  }
  
  .timeline {
    padding-left: 1.5rem;
  }
  
  .timeline::before {
    left: 11px;
  }
  
  .timeline-marker {
    left: -1.5rem;
    width: 24px;
    height: 24px;
  }
  
  .action-buttons {
    flex-direction: column;
    align-items: center;
  }
  
  .btn-action {
    width: 100%;
    max-width: 300px;
    justify-content: center;
  }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const form = document.getElementById('formSuivi');
  const submitBtn = form?.querySelector('.btn-submit');
  
  if (form) {
    form.addEventListener('submit', function(event) {
      if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
      } else {
        // Ajouter la classe de chargement au bouton
        submitBtn.classList.add('loading');
        submitBtn.disabled = true;
      }
      
      form.classList.add('was-validated');
    }, false);
  }
  
  // Auto-uppercase pour le numéro de dossier
  const numeroInput = document.getElementById('numero_dossier');
  if (numeroInput) {
    numeroInput.addEventListener('input', function() {
      this.value = this.value.toUpperCase();
    });
  }
});
</script>

<!-- Inclure le footer -->
<?php include 'footer.php'; ?>