<?php
session_start();

// Base URL dynamique (public/ est ta racine HTTP)
$base_url = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])), '/\\');
if ($base_url === '/' || $base_url === '.') { $base_url = ''; }

define('BASE_URL',   $base_url);
define('ASSETS_URL', BASE_URL . '/assets');
define('DOCS_URL',   BASE_URL . '/docs');

// ⚠️ Corrige le chemin pour être **relatif à ce fichier**
require_once __DIR__ . '/db.php';

// Génère un numéro de dossier
function genererNumeroDossier(string $type): string {
  $prefix = ($type === 'ethique') ? 'CI-ETH-' : 'CI-SUG-';
  return $prefix . strtoupper(substr(uniqid(), -6));
}

